% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otpr_get_isochrone.R
\name{otp_get_isochrone}
\alias{otp_get_isochrone}
\title{Returns one or more travel time isochrones in GeoJSON format}
\usage{
otp_get_isochrone(otpcon, location, fromLocation = TRUE,
  mode = "TRANSIT", date, time, cutoffs, batch = TRUE,
  arriveBy = FALSE, maxWalkDistance = 800, walkReluctance = 2,
  transferPenalty = 0, minTransferTime = 0)
}
\arguments{
\item{otpcon}{An OTP connection object produced by \code{\link{otp_connect}}.}

\item{location}{Numeric vector, Latitude/Longitude pair, e.g. `c(53.48805, -2.24258)`}

\item{fromLocation}{Logical. If TRUE (default) the isochrone
will be generated \emph{from} the \code{location}. If FALSE the isochrone will be generated
\emph{to} the \code{location}.}

\item{mode}{Character, mode of travel. Valid values are: WALK, TRANSIT, BUS, or RAIL.
Note that WALK mode is automatically included for TRANSIT, BUS and RAIL. TRANSIT will use all
available transit modes. Default is TRANSIT.}

\item{date}{Character, must be in the format mm-dd-yyyy. This is the desired date of travel.
Only relevant if \code{mode} includes public transport. Default is current system date.}

\item{time}{Character, must be in the format hh:mm:ss. If \code{arriveBy} is FALSE (the default)
this is the desired departure time, otherwise the desired arrival time. Default
is current system time.}

\item{cutoffs}{Numeric vector, containing the cutoff times in seconds, for
example: 'c(900, 1800. 2700)'
would request 15, 30 and 60 minute isochrones. Can be a single value.}

\item{batch}{Logical. If true, goal direction is turned off and a full path tree is built}

\item{arriveBy}{Logical. Whether the specified date and time is for
departure (FALSE) or arrival (TRUE). Default is FALSE.}

\item{maxWalkDistance}{Numeric. The maximum distance (in meters) the user is
willing to walk. Default = 800.}

\item{walkReluctance}{Integer. A multiplier for how bad walking is, compared
to being in transit for equal lengths of time. Default = 2.}

\item{transferPenalty}{Integer. An additional penalty added to boardings after
the first. The value is in OTP's internal weight units, which are roughly equivalent
to seconds. Set this to a high value to discourage transfers. Default is 0.}

\item{minTransferTime}{Integer. The minimum time, in seconds, between successive
trips on different vehicles. This is designed to allow for imperfect schedule
adherence. This is a minimum; transfers over longer distances might use a longer time.
Default is 0.}
}
\value{
Returns a list. First element in the list is \code{errorId}. This is "OK" if
OTP has returned GeoJSON, otherwise it is "ERROR". The second element of list
varies:
\itemize{
\item If \code{errorId} is "ERROR" then \code{response} contains the OTP error message.
\item If \code{errorId} is "OK" then \code{response} contains the GeoJSON for the isochrone(s).
}
}
\description{
Returns one or more travel time isochrone in GeoJSON format. Only works correctly for
walk and/or transit modes - a limitation of OTP. Isochrones can be generated either
\emph{from} a location or \emph{to} a location.
}
\examples{
\dontrun{
otp_get_isochrone(otpcon, location = c(53.48805, -2.24258), cutoffs = c(900, 1800, 2700))

otp_get_isochrone(otpcon, location = c(53.48805, -2.24258), fromLocation = FALSE,
cutoffs = c(900, 1800, 2700), mode = "BUS")
}
}
