% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtlColocalisationVariantQuery.R
\name{qtlColocalisationVariantQuery}
\alias{qtlColocalisationVariantQuery}
\title{Retrieve  QTL colocalisation results of a variant}
\usage{
qtlColocalisationVariantQuery(study_id, variant_id)
}
\arguments{
\item{study_id}{Character:  Study ID(s) generated by Open Targets Genetics (e.g GCST90002357).}

\item{variant_id}{Character: generated ID for variants by Open Targets Genetics (e.g. 1_154119580_C_A) or rsId (rs2494663).}
}
\value{
Returns a data frame of the colocalisation information for a lead variant in a specific study.
The output is a tidy data frame with the following data structure:
\itemize{
  \item{\code{qtlStudyName}:} \emph{Character vector}. QTL study name.
  \item{\code{phenotypeId}:} \emph{Character vector}. Phenotype ID.
  \item{\code{gene.id}:} \emph{Character vector}. Gene ID.
  \item{\code{gene.symbol}:} \emph{Character vector}. Gene symbol.
  \item{\code{name}:} \emph{Character vector}. Tissue name.
  \item{\code{indexVariant.id}:} \emph{Character vector}. Index variant ID.
  \item{\code{indexVariant.rsId}:} \emph{Character vector}. Index variant rsID.
  \item{\code{beta}:} \emph{Numeric}. Beta value.
  \item{\code{h4}:} \emph{Numeric}. h4 value.
  \item{\code{h3}:} \emph{Numeric}. h3 value.
  \item{\code{log2h4h3}:} \emph{Numeric}. Log2(h4/h3) value.
}
}
\description{
The colocalisation analysis in Open Target Genetics is performed using the coloc method (Giambartolomei et al., 2014).
  Coloc is a Bayesian method which, for two traits, integrates evidence over all variants
  at a locus to evaluate the following hypotheses:
  - H0: No association with either trait
  - H1: Association with trait 1, not with trait 2
  - H2: Association with trait 2, not with trait 1
  - H3: Association with trait 1 and trait 2, two independent SNPs
  - H4: Association with trait 1 and trait 2, one shared SNP
  This analysis tests whether two independent associations at the same locus are consistent
  with having a shared causal variant. Colocalisation of two independent associations from two GWAS studies may suggest a shared causal mechanism.
}
\examples{
\dontrun{
result <- qtlColocalisationVariantQuery(study_id = "GCST90002357", variant_id = "1_154119580_C_A")
result <- qtlColocalisationVariantQuery(study_id = "GCST90002357", variant_id = "rs2494663")
}
}
