% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtlCredibleSet.R
\name{qtlCredibleSet}
\alias{qtlCredibleSet}
\title{Retrieve calculated QTL summary statistics for credible variant set.}
\usage{
qtlCredibleSet(study_id, variant_id, gene, biofeature)
}
\arguments{
\item{study_id}{Character:  Study ID(s) generated by Open Targets Genetics (e.g GCST90002357).}

\item{variant_id}{Character: generated ID for variants by Open Targets Genetics (e.g. 1_154119580_C_A) or rsId (rs2494663).}

\item{gene}{Character: Gene ENSEMBL ID (e.g. ENSG00000169174) or gene symbol (e.g. PCSK9).}

\item{biofeature}{Character: Represents either a tissue, cell type, aggregation type, protein type, etc.}
}
\value{
Returns a data frame of results from the QTL credible set of variants consisting of the following columns:
\itemize{
  \item{\code{tagVariant.id}:} \emph{Character vector}. Tag variant ID.
  \item{\code{tagVariant.rsId}:} \emph{Character vector}. Tag variant rsID.
  \item{\code{pval}:} \emph{Numeric}. P-value.
  \item{\code{se}:} \emph{Numeric}. Standard error.
  \item{\code{beta}:} \emph{Numeric}. Beta value.
  \item{\code{postProb}:} \emph{Numeric}. Posterior probability.
  \item{\code{MultisignalMethod}:} \emph{Character vector}. Multisignal method.
  \item{\code{logABF}:} \emph{Numeric}. Logarithm of approximate Bayes factor.
  \item{\code{is95}:} \emph{Logical}. Indicates if the variant has a 95% confidence.
  \item{\code{is99}:} \emph{Logical}. Indicates if the variant has a 99% confidence.
}
}
\description{
In Open Targets Genetics, the lead variants are expanded into a more comprehensive set of candidate causal variants referred to as the tag variants.
This function retrieves calculated summary statistics for tag variants included in a lead variant colocalization analysis for a
given study (which links a top loci with a trait). The user can filter the results by desired biofeature (e.g tissue, cell type,...)
the function obtains tag variant information.
}
\examples{
\dontrun{
result <- qtlCredibleSet(study_id = "Braineac2", variant_id = "1_55053079_C_T",
    gene = "ENSG00000169174", biofeature = "SUBSTANTIA_NIGRA")
result <- qtlCredibleSet(study_id = "Braineac2", variant_id = "rs7552841",
    gene = "PCSK9", biofeature = "SUBSTANTIA_NIGRA")
}

}
