#ifndef LIN_ALG_DATA_H
#define LIN_ALG_DATA_H
#include "osqp.h"


/* create data and solutions structure */
typedef struct {
csc * test_sp_matrix_A;
c_float * test_sp_matrix_Adns;
c_int test_vec_ops_n;
c_float * test_vec_ops_v1;
c_float * test_vec_ops_v2;
c_float test_vec_ops_sc;
c_float test_vec_ops_norm_inf;
c_float test_vec_ops_norm_inf_diff;
c_float * test_vec_ops_add_scaled;
c_float * test_vec_ops_ew_reciprocal;
c_float test_vec_ops_vec_prod;
c_float * test_vec_ops_ew_max_vec;
c_float * test_vec_ops_ew_min_vec;
c_int test_mat_ops_n;
csc * test_mat_ops_A;
c_float * test_mat_ops_d;
csc * test_mat_ops_prem_diag;
csc * test_mat_ops_postm_diag;
c_float * test_mat_ops_inf_norm_cols;
c_float * test_mat_ops_inf_norm_rows;
c_int test_mat_vec_n;
c_int test_mat_vec_m;
csc * test_mat_vec_A;
csc * test_mat_vec_Pu;
c_float * test_mat_vec_x;
c_float * test_mat_vec_y;
c_float * test_mat_vec_Ax;
c_float * test_mat_vec_Ax_cum;
c_float * test_mat_vec_ATy;
c_float * test_mat_vec_ATy_cum;
c_float * test_mat_vec_Px;
c_float * test_mat_vec_Px_cum;
c_int test_mat_extr_triu_n;
csc * test_mat_extr_triu_P;
csc * test_mat_extr_triu_Pu;
c_float * test_mat_extr_triu_P_inf_norm_cols;
c_int test_qpform_n;
csc * test_qpform_Pu;
c_float * test_qpform_x;
c_float test_qpform_value;
} lin_alg_sols_data;

/* function prototypes */
lin_alg_sols_data *  generate_problem_lin_alg_sols_data();
void clean_problem_lin_alg_sols_data(lin_alg_sols_data * data);


/* function to define problem data */
lin_alg_sols_data *  generate_problem_lin_alg_sols_data(){

lin_alg_sols_data * data = (lin_alg_sols_data *)c_malloc(sizeof(lin_alg_sols_data));


// Matrix test_sp_matrix_A
//------------------------
data->test_sp_matrix_A = (csc*) c_malloc(sizeof(csc));
data->test_sp_matrix_A->m = 5;
data->test_sp_matrix_A->n = 6;
data->test_sp_matrix_A->nz = -1;
data->test_sp_matrix_A->nzmax = 30;
data->test_sp_matrix_A->x = (c_float*) c_malloc(30 * sizeof(c_float));
data->test_sp_matrix_A->x[0] = -1.42121722730412680669;
data->test_sp_matrix_A->x[1] = 0.37044453666323423624;
data->test_sp_matrix_A->x[2] = -0.31350819699340887192;
data->test_sp_matrix_A->x[3] = 1.61134077957371735224;
data->test_sp_matrix_A->x[4] = -0.37566942307899364728;
data->test_sp_matrix_A->x[5] = -0.15349519567694913658;
data->test_sp_matrix_A->x[6] = 1.35963386267259611628;
data->test_sp_matrix_A->x[7] = 0.77101173806941147859;
data->test_sp_matrix_A->x[8] = 0.04797059186818837528;
data->test_sp_matrix_A->x[9] = -0.07447076289398098237;
data->test_sp_matrix_A->x[10] = -0.26905696021601349655;
data->test_sp_matrix_A->x[11] = 0.50185720678131329198;
data->test_sp_matrix_A->x[12] = -1.86809065456376344194;
data->test_sp_matrix_A->x[13] = -0.82913528901477873134;
data->test_sp_matrix_A->x[14] = 0.43349633007657084605;
data->test_sp_matrix_A->x[15] = 2.23136678888660444642;
data->test_sp_matrix_A->x[16] = -0.84421370382986182790;
data->test_sp_matrix_A->x[17] = 1.73118466598046794047;
data->test_sp_matrix_A->x[18] = 0.08771021840833141681;
data->test_sp_matrix_A->x[19] = 1.27837923027186817215;
data->test_sp_matrix_A->x[20] = -2.43476757652104414120;
data->test_sp_matrix_A->x[21] = 0.00000976147159609348;
data->test_sp_matrix_A->x[22] = 2.46767801057341262805;
data->test_sp_matrix_A->x[23] = 1.00036588655069502707;
data->test_sp_matrix_A->x[24] = -0.63467930517936232970;
data->test_sp_matrix_A->x[25] = 0.11272650481664892030;
data->test_sp_matrix_A->x[26] = 0.54235257214902909961;
data->test_sp_matrix_A->x[27] = -0.33567733852384745719;
data->test_sp_matrix_A->x[28] = -0.38109251751534994890;
data->test_sp_matrix_A->x[29] = 0.50839624268343175384;
data->test_sp_matrix_A->i = (c_int*) c_malloc(30 * sizeof(c_int));
data->test_sp_matrix_A->i[0] = 0;
data->test_sp_matrix_A->i[1] = 1;
data->test_sp_matrix_A->i[2] = 2;
data->test_sp_matrix_A->i[3] = 3;
data->test_sp_matrix_A->i[4] = 4;
data->test_sp_matrix_A->i[5] = 0;
data->test_sp_matrix_A->i[6] = 1;
data->test_sp_matrix_A->i[7] = 2;
data->test_sp_matrix_A->i[8] = 3;
data->test_sp_matrix_A->i[9] = 4;
data->test_sp_matrix_A->i[10] = 0;
data->test_sp_matrix_A->i[11] = 1;
data->test_sp_matrix_A->i[12] = 2;
data->test_sp_matrix_A->i[13] = 3;
data->test_sp_matrix_A->i[14] = 4;
data->test_sp_matrix_A->i[15] = 0;
data->test_sp_matrix_A->i[16] = 1;
data->test_sp_matrix_A->i[17] = 2;
data->test_sp_matrix_A->i[18] = 3;
data->test_sp_matrix_A->i[19] = 4;
data->test_sp_matrix_A->i[20] = 0;
data->test_sp_matrix_A->i[21] = 1;
data->test_sp_matrix_A->i[22] = 2;
data->test_sp_matrix_A->i[23] = 3;
data->test_sp_matrix_A->i[24] = 4;
data->test_sp_matrix_A->i[25] = 0;
data->test_sp_matrix_A->i[26] = 1;
data->test_sp_matrix_A->i[27] = 2;
data->test_sp_matrix_A->i[28] = 3;
data->test_sp_matrix_A->i[29] = 4;
data->test_sp_matrix_A->p = (c_int*) c_malloc((6 + 1) * sizeof(c_int));
data->test_sp_matrix_A->p[0] = 0;
data->test_sp_matrix_A->p[1] = 5;
data->test_sp_matrix_A->p[2] = 10;
data->test_sp_matrix_A->p[3] = 15;
data->test_sp_matrix_A->p[4] = 20;
data->test_sp_matrix_A->p[5] = 25;
data->test_sp_matrix_A->p[6] = 30;

data->test_sp_matrix_Adns = (c_float*) c_malloc(30 * sizeof(c_float));
data->test_sp_matrix_Adns[0] = -1.42121722730412680669;
data->test_sp_matrix_Adns[1] = 0.37044453666323423624;
data->test_sp_matrix_Adns[2] = -0.31350819699340887192;
data->test_sp_matrix_Adns[3] = 1.61134077957371735224;
data->test_sp_matrix_Adns[4] = -0.37566942307899364728;
data->test_sp_matrix_Adns[5] = -0.15349519567694913658;
data->test_sp_matrix_Adns[6] = 1.35963386267259611628;
data->test_sp_matrix_Adns[7] = 0.77101173806941147859;
data->test_sp_matrix_Adns[8] = 0.04797059186818837528;
data->test_sp_matrix_Adns[9] = -0.07447076289398098237;
data->test_sp_matrix_Adns[10] = -0.26905696021601349655;
data->test_sp_matrix_Adns[11] = 0.50185720678131329198;
data->test_sp_matrix_Adns[12] = -1.86809065456376344194;
data->test_sp_matrix_Adns[13] = -0.82913528901477873134;
data->test_sp_matrix_Adns[14] = 0.43349633007657084605;
data->test_sp_matrix_Adns[15] = 2.23136678888660444642;
data->test_sp_matrix_Adns[16] = -0.84421370382986182790;
data->test_sp_matrix_Adns[17] = 1.73118466598046794047;
data->test_sp_matrix_Adns[18] = 0.08771021840833141681;
data->test_sp_matrix_Adns[19] = 1.27837923027186817215;
data->test_sp_matrix_Adns[20] = -2.43476757652104414120;
data->test_sp_matrix_Adns[21] = 0.00000976147159609348;
data->test_sp_matrix_Adns[22] = 2.46767801057341262805;
data->test_sp_matrix_Adns[23] = 1.00036588655069502707;
data->test_sp_matrix_Adns[24] = -0.63467930517936232970;
data->test_sp_matrix_Adns[25] = 0.11272650481664892030;
data->test_sp_matrix_Adns[26] = 0.54235257214902909961;
data->test_sp_matrix_Adns[27] = -0.33567733852384745719;
data->test_sp_matrix_Adns[28] = -0.38109251751534994890;
data->test_sp_matrix_Adns[29] = 0.50839624268343175384;
data->test_vec_ops_n = 10;
data->test_vec_ops_v1 = (c_float*) c_malloc(10 * sizeof(c_float));
data->test_vec_ops_v1[0] = 0.21611600626368202005;
data->test_vec_ops_v1[1] = -1.85861238612349755073;
data->test_vec_ops_v1[2] = -0.41931648215268885194;
data->test_vec_ops_v1[3] = -0.13232889843674336405;
data->test_vec_ops_v1[4] = -0.03957023969360570076;
data->test_vec_ops_v1[5] = 0.32600343338698062334;
data->test_vec_ops_v1[6] = -2.04032304872871517176;
data->test_vec_ops_v1[7] = 0.04625552314169690399;
data->test_vec_ops_v1[8] = -0.67767557732804151183;
data->test_vec_ops_v1[9] = -1.43943902673861812147;
data->test_vec_ops_v2 = (c_float*) c_malloc(10 * sizeof(c_float));
data->test_vec_ops_v2[0] = 0.52429643001034864636;
data->test_vec_ops_v2[1] = 0.73527957606520255585;
data->test_vec_ops_v2[2] = -0.65325026779203565486;
data->test_vec_ops_v2[3] = 0.84245628157134011538;
data->test_vec_ops_v2[4] = -0.38151648176508617949;
data->test_vec_ops_v2[5] = 0.06648900914614486179;
data->test_vec_ops_v2[6] = -1.09873894699605645364;
data->test_vec_ops_v2[7] = 1.58448705639567632986;
data->test_vec_ops_v2[8] = -2.65944945638348828609;
data->test_vec_ops_v2[9] = -0.09145262289065814176;
data->test_vec_ops_sc = 0.69511960504699144003;
data->test_vec_ops_norm_inf = 2.04032304872871517176;
data->test_vec_ops_norm_inf_diff = 2.59389196218869999555;
data->test_vec_ops_add_scaled = (c_float*) c_malloc(10 * sizeof(c_float));
data->test_vec_ops_add_scaled[0] = 0.58056473362002314342;
data->test_vec_ops_add_scaled[1] = -1.34750513760993451129;
data->test_vec_ops_add_scaled[2] = -0.87340355029713001578;
data->test_vec_ops_add_scaled[3] = 0.45327897927848359583;
data->test_vec_ops_add_scaled[4] = -0.30476982581707007247;
data->test_vec_ops_add_scaled[5] = 0.37222124716461463256;
data->test_vec_ops_add_scaled[6] = -2.80407803161436142148;
data->test_vec_ops_add_scaled[7] = 1.14766353998552950166;
data->test_vec_ops_add_scaled[8] = -2.52631103309176818783;
data->test_vec_ops_add_scaled[9] = -1.50300953784288382487;
data->test_vec_ops_ew_reciprocal = (c_float*) c_malloc(10 * sizeof(c_float));
data->test_vec_ops_ew_reciprocal[0] = 4.62714454745154402104;
data->test_vec_ops_ew_reciprocal[1] = -0.53803579889279495863;
data->test_vec_ops_ew_reciprocal[2] = -2.38483351492933337568;
data->test_vec_ops_ew_reciprocal[3] = -7.55692831885867999375;
data->test_vec_ops_ew_reciprocal[4] = -25.27151737626683214444;
data->test_vec_ops_ew_reciprocal[5] = 3.06745235659207127199;
data->test_vec_ops_ew_reciprocal[6] = -0.49011846463386282702;
data->test_vec_ops_ew_reciprocal[7] = 21.61903989144494175889;
data->test_vec_ops_ew_reciprocal[8] = -1.47563234304949930653;
data->test_vec_ops_ew_reciprocal[9] = -0.69471508096159595436;
data->test_vec_ops_vec_prod = 3.19487685565542900434;
data->test_vec_ops_ew_max_vec = (c_float*) c_malloc(10 * sizeof(c_float));
data->test_vec_ops_ew_max_vec[0] = 0.52429643001034864636;
data->test_vec_ops_ew_max_vec[1] = 0.73527957606520255585;
data->test_vec_ops_ew_max_vec[2] = -0.41931648215268885194;
data->test_vec_ops_ew_max_vec[3] = 0.84245628157134011538;
data->test_vec_ops_ew_max_vec[4] = -0.03957023969360570076;
data->test_vec_ops_ew_max_vec[5] = 0.32600343338698062334;
data->test_vec_ops_ew_max_vec[6] = -1.09873894699605645364;
data->test_vec_ops_ew_max_vec[7] = 1.58448705639567632986;
data->test_vec_ops_ew_max_vec[8] = -0.67767557732804151183;
data->test_vec_ops_ew_max_vec[9] = -0.09145262289065814176;
data->test_vec_ops_ew_min_vec = (c_float*) c_malloc(10 * sizeof(c_float));
data->test_vec_ops_ew_min_vec[0] = 0.21611600626368202005;
data->test_vec_ops_ew_min_vec[1] = -1.85861238612349755073;
data->test_vec_ops_ew_min_vec[2] = -0.65325026779203565486;
data->test_vec_ops_ew_min_vec[3] = -0.13232889843674336405;
data->test_vec_ops_ew_min_vec[4] = -0.38151648176508617949;
data->test_vec_ops_ew_min_vec[5] = 0.06648900914614486179;
data->test_vec_ops_ew_min_vec[6] = -2.04032304872871517176;
data->test_vec_ops_ew_min_vec[7] = 0.04625552314169690399;
data->test_vec_ops_ew_min_vec[8] = -2.65944945638348828609;
data->test_vec_ops_ew_min_vec[9] = -1.43943902673861812147;
data->test_mat_ops_n = 2;

// Matrix test_mat_ops_A
//----------------------
data->test_mat_ops_A = (csc*) c_malloc(sizeof(csc));
data->test_mat_ops_A->m = 2;
data->test_mat_ops_A->n = 2;
data->test_mat_ops_A->nz = -1;
data->test_mat_ops_A->nzmax = 3;
data->test_mat_ops_A->x = (c_float*) c_malloc(3 * sizeof(c_float));
data->test_mat_ops_A->x[0] = 0.04179770981531005791;
data->test_mat_ops_A->x[1] = 0.31325852842971357859;
data->test_mat_ops_A->x[2] = 0.73839975862090034830;
data->test_mat_ops_A->i = (c_int*) c_malloc(3 * sizeof(c_int));
data->test_mat_ops_A->i[0] = 0;
data->test_mat_ops_A->i[1] = 1;
data->test_mat_ops_A->i[2] = 0;
data->test_mat_ops_A->p = (c_int*) c_malloc((2 + 1) * sizeof(c_int));
data->test_mat_ops_A->p[0] = 0;
data->test_mat_ops_A->p[1] = 2;
data->test_mat_ops_A->p[2] = 3;

data->test_mat_ops_d = (c_float*) c_malloc(2 * sizeof(c_float));
data->test_mat_ops_d[0] = -2.03346654612261357187;
data->test_mat_ops_d[1] = -1.14533805578424119354;

// Matrix test_mat_ops_prem_diag
//------------------------------
data->test_mat_ops_prem_diag = (csc*) c_malloc(sizeof(csc));
data->test_mat_ops_prem_diag->m = 2;
data->test_mat_ops_prem_diag->n = 2;
data->test_mat_ops_prem_diag->nz = -1;
data->test_mat_ops_prem_diag->nzmax = 3;
data->test_mat_ops_prem_diag->x = (c_float*) c_malloc(3 * sizeof(c_float));
data->test_mat_ops_prem_diag->x[0] = -0.08499424461397381281;
data->test_mat_ops_prem_diag->x[1] = -0.35878691390952061058;
data->test_mat_ops_prem_diag->x[2] = -1.50151120682061378631;
data->test_mat_ops_prem_diag->i = (c_int*) c_malloc(3 * sizeof(c_int));
data->test_mat_ops_prem_diag->i[0] = 0;
data->test_mat_ops_prem_diag->i[1] = 1;
data->test_mat_ops_prem_diag->i[2] = 0;
data->test_mat_ops_prem_diag->p = (c_int*) c_malloc((2 + 1) * sizeof(c_int));
data->test_mat_ops_prem_diag->p[0] = 0;
data->test_mat_ops_prem_diag->p[1] = 2;
data->test_mat_ops_prem_diag->p[2] = 3;


// Matrix test_mat_ops_postm_diag
//-------------------------------
data->test_mat_ops_postm_diag = (csc*) c_malloc(sizeof(csc));
data->test_mat_ops_postm_diag->m = 2;
data->test_mat_ops_postm_diag->n = 2;
data->test_mat_ops_postm_diag->nz = -1;
data->test_mat_ops_postm_diag->nzmax = 3;
data->test_mat_ops_postm_diag->x = (c_float*) c_malloc(3 * sizeof(c_float));
data->test_mat_ops_postm_diag->x[0] = -0.08499424461397381281;
data->test_mat_ops_postm_diag->x[1] = -0.63700073784942223831;
data->test_mat_ops_postm_diag->x[2] = -0.84571734393041497757;
data->test_mat_ops_postm_diag->i = (c_int*) c_malloc(3 * sizeof(c_int));
data->test_mat_ops_postm_diag->i[0] = 0;
data->test_mat_ops_postm_diag->i[1] = 1;
data->test_mat_ops_postm_diag->i[2] = 0;
data->test_mat_ops_postm_diag->p = (c_int*) c_malloc((2 + 1) * sizeof(c_int));
data->test_mat_ops_postm_diag->p[0] = 0;
data->test_mat_ops_postm_diag->p[1] = 2;
data->test_mat_ops_postm_diag->p[2] = 3;

data->test_mat_ops_inf_norm_cols = (c_float*) c_malloc(2 * sizeof(c_float));
data->test_mat_ops_inf_norm_cols[0] = 0.31325852842971357859;
data->test_mat_ops_inf_norm_cols[1] = 0.73839975862090034830;
data->test_mat_ops_inf_norm_rows = (c_float*) c_malloc(2 * sizeof(c_float));
data->test_mat_ops_inf_norm_rows[0] = 0.73839975862090034830;
data->test_mat_ops_inf_norm_rows[1] = 0.31325852842971357859;
data->test_mat_vec_n = 4;
data->test_mat_vec_m = 5;

// Matrix test_mat_vec_A
//----------------------
data->test_mat_vec_A = (csc*) c_malloc(sizeof(csc));
data->test_mat_vec_A->m = 5;
data->test_mat_vec_A->n = 4;
data->test_mat_vec_A->nz = -1;
data->test_mat_vec_A->nzmax = 20;
data->test_mat_vec_A->x = (c_float*) c_malloc(20 * sizeof(c_float));
data->test_mat_vec_A->x[0] = 0.62935972282958219104;
data->test_mat_vec_A->x[1] = 0.54790778009037666152;
data->test_mat_vec_A->x[2] = 0.18662714558648019203;
data->test_mat_vec_A->x[3] = 0.48926616699485914186;
data->test_mat_vec_A->x[4] = 0.91391547716513199529;
data->test_mat_vec_A->x[5] = 0.24581116390413071393;
data->test_mat_vec_A->x[6] = 0.54019151566713086154;
data->test_mat_vec_A->x[7] = 0.60844215780504962154;
data->test_mat_vec_A->x[8] = 0.41973546130682071187;
data->test_mat_vec_A->x[9] = 0.82624982843415795131;
data->test_mat_vec_A->x[10] = 0.11058314779616107426;
data->test_mat_vec_A->x[11] = 0.27405925253605367686;
data->test_mat_vec_A->x[12] = 0.59125735265354584236;
data->test_mat_vec_A->x[13] = 0.34623790945514643091;
data->test_mat_vec_A->x[14] = 0.29517230521974247015;
data->test_mat_vec_A->x[15] = 0.69952061979054813712;
data->test_mat_vec_A->x[16] = 0.01025003939959090449;
data->test_mat_vec_A->x[17] = 0.17671216158442604183;
data->test_mat_vec_A->x[18] = 0.62356318456213077894;
data->test_mat_vec_A->x[19] = 0.26377852928001976895;
data->test_mat_vec_A->i = (c_int*) c_malloc(20 * sizeof(c_int));
data->test_mat_vec_A->i[0] = 0;
data->test_mat_vec_A->i[1] = 1;
data->test_mat_vec_A->i[2] = 2;
data->test_mat_vec_A->i[3] = 3;
data->test_mat_vec_A->i[4] = 4;
data->test_mat_vec_A->i[5] = 0;
data->test_mat_vec_A->i[6] = 1;
data->test_mat_vec_A->i[7] = 2;
data->test_mat_vec_A->i[8] = 3;
data->test_mat_vec_A->i[9] = 4;
data->test_mat_vec_A->i[10] = 0;
data->test_mat_vec_A->i[11] = 1;
data->test_mat_vec_A->i[12] = 2;
data->test_mat_vec_A->i[13] = 3;
data->test_mat_vec_A->i[14] = 4;
data->test_mat_vec_A->i[15] = 0;
data->test_mat_vec_A->i[16] = 1;
data->test_mat_vec_A->i[17] = 2;
data->test_mat_vec_A->i[18] = 3;
data->test_mat_vec_A->i[19] = 4;
data->test_mat_vec_A->p = (c_int*) c_malloc((4 + 1) * sizeof(c_int));
data->test_mat_vec_A->p[0] = 0;
data->test_mat_vec_A->p[1] = 5;
data->test_mat_vec_A->p[2] = 10;
data->test_mat_vec_A->p[3] = 15;
data->test_mat_vec_A->p[4] = 20;


// Matrix test_mat_vec_Pu
//-----------------------
data->test_mat_vec_Pu = (csc*) c_malloc(sizeof(csc));
data->test_mat_vec_Pu->m = 4;
data->test_mat_vec_Pu->n = 4;
data->test_mat_vec_Pu->nz = -1;
data->test_mat_vec_Pu->nzmax = 9;
data->test_mat_vec_Pu->x = (c_float*) c_malloc(9 * sizeof(c_float));
data->test_mat_vec_Pu->x[0] = 0.43857994482138584758;
data->test_mat_vec_Pu->x[1] = 0.83651764852853427445;
data->test_mat_vec_Pu->x[2] = 0.97447737597704364720;
data->test_mat_vec_Pu->x[3] = 1.00661727616937901608;
data->test_mat_vec_Pu->x[4] = 1.01082326817688716858;
data->test_mat_vec_Pu->x[5] = 0.03438029526287300630;
data->test_mat_vec_Pu->x[6] = 0.38658285361775701627;
data->test_mat_vec_Pu->x[7] = 0.54587270844450219709;
data->test_mat_vec_Pu->x[8] = 1.24654467104204758066;
data->test_mat_vec_Pu->i = (c_int*) c_malloc(9 * sizeof(c_int));
data->test_mat_vec_Pu->i[0] = 0;
data->test_mat_vec_Pu->i[1] = 0;
data->test_mat_vec_Pu->i[2] = 0;
data->test_mat_vec_Pu->i[3] = 1;
data->test_mat_vec_Pu->i[4] = 2;
data->test_mat_vec_Pu->i[5] = 0;
data->test_mat_vec_Pu->i[6] = 1;
data->test_mat_vec_Pu->i[7] = 2;
data->test_mat_vec_Pu->i[8] = 3;
data->test_mat_vec_Pu->p = (c_int*) c_malloc((4 + 1) * sizeof(c_int));
data->test_mat_vec_Pu->p[0] = 0;
data->test_mat_vec_Pu->p[1] = 1;
data->test_mat_vec_Pu->p[2] = 2;
data->test_mat_vec_Pu->p[3] = 5;
data->test_mat_vec_Pu->p[4] = 9;

data->test_mat_vec_x = (c_float*) c_malloc(4 * sizeof(c_float));
data->test_mat_vec_x[0] = 0.63219176742504867850;
data->test_mat_vec_x[1] = -0.16069401520370646397;
data->test_mat_vec_x[2] = 0.63892585952791103310;
data->test_mat_vec_x[3] = -0.24716477598647346170;
data->test_mat_vec_y = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_mat_vec_y[0] = -0.71420877608252808511;
data->test_mat_vec_y[1] = -0.03773763968449992540;
data->test_mat_vec_y[2] = -0.36324145137227209501;
data->test_mat_vec_y[3] = 0.05228168709825962990;
data->test_mat_vec_y[4] = 0.00926374048213370570;
data->test_mat_vec_Ax = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_mat_vec_Ax[0] = 0.25613322807863547759;
data->test_mat_vec_Ax[1] = 0.43214733904586549729;
data->test_mat_vec_Ax[2] = 0.35430372207517196737;
data->test_mat_vec_Ax[3] = 0.30895856532705145980;
data->test_mat_vec_Ax[4] = 0.56839289601549436437;
data->test_mat_vec_Ax_cum = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_mat_vec_Ax_cum[0] = -0.45807554800389260752;
data->test_mat_vec_Ax_cum[1] = 0.39440969936136555107;
data->test_mat_vec_Ax_cum[2] = -0.00893772929710012765;
data->test_mat_vec_Ax_cum[3] = 0.36124025242531110358;
data->test_mat_vec_Ax_cum[4] = 0.57765663649762810650;
data->test_mat_vec_ATy = (c_float*) c_malloc(4 * sizeof(c_float));
data->test_mat_vec_ATy[0] = -0.50391576251778413820;
data->test_mat_vec_ATy[1] = -0.38735881373933578331;
data->test_mat_vec_ATy[2] = -0.28325468120290137053;
data->test_mat_vec_ATy[3] = -0.52913524890649032972;
data->test_mat_vec_ATy_cum = (c_float*) c_malloc(4 * sizeof(c_float));
data->test_mat_vec_ATy_cum[0] = 0.12827600490726454030;
data->test_mat_vec_ATy_cum[1] = -0.54805282894304219177;
data->test_mat_vec_ATy_cum[2] = 0.35567117832500966257;
data->test_mat_vec_ATy_cum[3] = -0.77630002489296379142;
data->test_mat_vec_Px = (c_float*) c_malloc(4 * sizeof(c_float));
data->test_mat_vec_Px[0] = 0.75696444780263838492;
data->test_mat_vec_Px[1] = 1.07644371468302035844;
data->test_mat_vec_Px[2] = 0.96521982250449001040;
data->test_mat_vec_Px[3] = 0.00028364373057909731;
data->test_mat_vec_Px_cum = (c_float*) c_malloc(4 * sizeof(c_float));
data->test_mat_vec_Px_cum[0] = 1.38915621522768706342;
data->test_mat_vec_Px_cum[1] = 0.91574969947931394998;
data->test_mat_vec_Px_cum[2] = 1.60414568203240115452;
data->test_mat_vec_Px_cum[3] = -0.24688113225589436439;
data->test_mat_extr_triu_n = 5;

// Matrix test_mat_extr_triu_P
//----------------------------
data->test_mat_extr_triu_P = (csc*) c_malloc(sizeof(csc));
data->test_mat_extr_triu_P->m = 5;
data->test_mat_extr_triu_P->n = 5;
data->test_mat_extr_triu_P->nz = -1;
data->test_mat_extr_triu_P->nzmax = 24;
data->test_mat_extr_triu_P->x = (c_float*) c_malloc(24 * sizeof(c_float));
data->test_mat_extr_triu_P->x[0] = 0.05040284734149791390;
data->test_mat_extr_triu_P->x[1] = 0.50587997442213683552;
data->test_mat_extr_triu_P->x[2] = 0.10213794823119348720;
data->test_mat_extr_triu_P->x[3] = 0.38833418211475911885;
data->test_mat_extr_triu_P->x[4] = 0.50608683351263883399;
data->test_mat_extr_triu_P->x[5] = 0.50587997442213683552;
data->test_mat_extr_triu_P->x[6] = 0.40168468755089081768;
data->test_mat_extr_triu_P->x[7] = 1.34373784051121503147;
data->test_mat_extr_triu_P->x[8] = 1.38502143529279786449;
data->test_mat_extr_triu_P->x[9] = 0.72419544786517398016;
data->test_mat_extr_triu_P->x[10] = 0.10213794823119348720;
data->test_mat_extr_triu_P->x[11] = 1.34373784051121503147;
data->test_mat_extr_triu_P->x[12] = 0.88078857676908040020;
data->test_mat_extr_triu_P->x[13] = 0.28325874382112081751;
data->test_mat_extr_triu_P->x[14] = 0.38833418211475911885;
data->test_mat_extr_triu_P->x[15] = 1.38502143529279786449;
data->test_mat_extr_triu_P->x[16] = 0.88078857676908040020;
data->test_mat_extr_triu_P->x[17] = 1.40452848163944987725;
data->test_mat_extr_triu_P->x[18] = 1.41895872401804234997;
data->test_mat_extr_triu_P->x[19] = 0.50608683351263883399;
data->test_mat_extr_triu_P->x[20] = 0.72419544786517398016;
data->test_mat_extr_triu_P->x[21] = 0.28325874382112081751;
data->test_mat_extr_triu_P->x[22] = 1.41895872401804234997;
data->test_mat_extr_triu_P->x[23] = 1.83342922391576501617;
data->test_mat_extr_triu_P->i = (c_int*) c_malloc(24 * sizeof(c_int));
data->test_mat_extr_triu_P->i[0] = 0;
data->test_mat_extr_triu_P->i[1] = 1;
data->test_mat_extr_triu_P->i[2] = 2;
data->test_mat_extr_triu_P->i[3] = 3;
data->test_mat_extr_triu_P->i[4] = 4;
data->test_mat_extr_triu_P->i[5] = 0;
data->test_mat_extr_triu_P->i[6] = 1;
data->test_mat_extr_triu_P->i[7] = 2;
data->test_mat_extr_triu_P->i[8] = 3;
data->test_mat_extr_triu_P->i[9] = 4;
data->test_mat_extr_triu_P->i[10] = 0;
data->test_mat_extr_triu_P->i[11] = 1;
data->test_mat_extr_triu_P->i[12] = 3;
data->test_mat_extr_triu_P->i[13] = 4;
data->test_mat_extr_triu_P->i[14] = 0;
data->test_mat_extr_triu_P->i[15] = 1;
data->test_mat_extr_triu_P->i[16] = 2;
data->test_mat_extr_triu_P->i[17] = 3;
data->test_mat_extr_triu_P->i[18] = 4;
data->test_mat_extr_triu_P->i[19] = 0;
data->test_mat_extr_triu_P->i[20] = 1;
data->test_mat_extr_triu_P->i[21] = 2;
data->test_mat_extr_triu_P->i[22] = 3;
data->test_mat_extr_triu_P->i[23] = 4;
data->test_mat_extr_triu_P->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_mat_extr_triu_P->p[0] = 0;
data->test_mat_extr_triu_P->p[1] = 5;
data->test_mat_extr_triu_P->p[2] = 10;
data->test_mat_extr_triu_P->p[3] = 14;
data->test_mat_extr_triu_P->p[4] = 19;
data->test_mat_extr_triu_P->p[5] = 24;


// Matrix test_mat_extr_triu_Pu
//-----------------------------
data->test_mat_extr_triu_Pu = (csc*) c_malloc(sizeof(csc));
data->test_mat_extr_triu_Pu->m = 5;
data->test_mat_extr_triu_Pu->n = 5;
data->test_mat_extr_triu_Pu->nz = -1;
data->test_mat_extr_triu_Pu->nzmax = 14;
data->test_mat_extr_triu_Pu->x = (c_float*) c_malloc(14 * sizeof(c_float));
data->test_mat_extr_triu_Pu->x[0] = 0.05040284734149791390;
data->test_mat_extr_triu_Pu->x[1] = 0.50587997442213683552;
data->test_mat_extr_triu_Pu->x[2] = 0.40168468755089081768;
data->test_mat_extr_triu_Pu->x[3] = 0.10213794823119348720;
data->test_mat_extr_triu_Pu->x[4] = 1.34373784051121503147;
data->test_mat_extr_triu_Pu->x[5] = 0.38833418211475911885;
data->test_mat_extr_triu_Pu->x[6] = 1.38502143529279786449;
data->test_mat_extr_triu_Pu->x[7] = 0.88078857676908040020;
data->test_mat_extr_triu_Pu->x[8] = 1.40452848163944987725;
data->test_mat_extr_triu_Pu->x[9] = 0.50608683351263883399;
data->test_mat_extr_triu_Pu->x[10] = 0.72419544786517398016;
data->test_mat_extr_triu_Pu->x[11] = 0.28325874382112081751;
data->test_mat_extr_triu_Pu->x[12] = 1.41895872401804234997;
data->test_mat_extr_triu_Pu->x[13] = 1.83342922391576501617;
data->test_mat_extr_triu_Pu->i = (c_int*) c_malloc(14 * sizeof(c_int));
data->test_mat_extr_triu_Pu->i[0] = 0;
data->test_mat_extr_triu_Pu->i[1] = 0;
data->test_mat_extr_triu_Pu->i[2] = 1;
data->test_mat_extr_triu_Pu->i[3] = 0;
data->test_mat_extr_triu_Pu->i[4] = 1;
data->test_mat_extr_triu_Pu->i[5] = 0;
data->test_mat_extr_triu_Pu->i[6] = 1;
data->test_mat_extr_triu_Pu->i[7] = 2;
data->test_mat_extr_triu_Pu->i[8] = 3;
data->test_mat_extr_triu_Pu->i[9] = 0;
data->test_mat_extr_triu_Pu->i[10] = 1;
data->test_mat_extr_triu_Pu->i[11] = 2;
data->test_mat_extr_triu_Pu->i[12] = 3;
data->test_mat_extr_triu_Pu->i[13] = 4;
data->test_mat_extr_triu_Pu->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_mat_extr_triu_Pu->p[0] = 0;
data->test_mat_extr_triu_Pu->p[1] = 1;
data->test_mat_extr_triu_Pu->p[2] = 3;
data->test_mat_extr_triu_Pu->p[3] = 5;
data->test_mat_extr_triu_Pu->p[4] = 9;
data->test_mat_extr_triu_Pu->p[5] = 14;

data->test_mat_extr_triu_P_inf_norm_cols = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_mat_extr_triu_P_inf_norm_cols[0] = 0.50608683351263883399;
data->test_mat_extr_triu_P_inf_norm_cols[1] = 1.38502143529279786449;
data->test_mat_extr_triu_P_inf_norm_cols[2] = 1.34373784051121503147;
data->test_mat_extr_triu_P_inf_norm_cols[3] = 1.41895872401804234997;
data->test_mat_extr_triu_P_inf_norm_cols[4] = 1.83342922391576501617;
data->test_qpform_n = 4;

// Matrix test_qpform_Pu
//----------------------
data->test_qpform_Pu = (csc*) c_malloc(sizeof(csc));
data->test_qpform_Pu->m = 4;
data->test_qpform_Pu->n = 4;
data->test_qpform_Pu->nz = -1;
data->test_qpform_Pu->nzmax = 10;
data->test_qpform_Pu->x = (c_float*) c_malloc(10 * sizeof(c_float));
data->test_qpform_Pu->x[0] = 1.72205535097422646196;
data->test_qpform_Pu->x[1] = 1.03687300123097436710;
data->test_qpform_Pu->x[2] = 0.81839929228148089457;
data->test_qpform_Pu->x[3] = 0.34443856731316913056;
data->test_qpform_Pu->x[4] = 0.75700463898986725120;
data->test_qpform_Pu->x[5] = 1.51300056342972855106;
data->test_qpform_Pu->x[6] = 0.86618024434956641944;
data->test_qpform_Pu->x[7] = 1.09921793659040889501;
data->test_qpform_Pu->x[8] = 0.22629616254814122200;
data->test_qpform_Pu->x[9] = 0.65169252761890983372;
data->test_qpform_Pu->i = (c_int*) c_malloc(10 * sizeof(c_int));
data->test_qpform_Pu->i[0] = 0;
data->test_qpform_Pu->i[1] = 0;
data->test_qpform_Pu->i[2] = 1;
data->test_qpform_Pu->i[3] = 0;
data->test_qpform_Pu->i[4] = 1;
data->test_qpform_Pu->i[5] = 2;
data->test_qpform_Pu->i[6] = 0;
data->test_qpform_Pu->i[7] = 1;
data->test_qpform_Pu->i[8] = 2;
data->test_qpform_Pu->i[9] = 3;
data->test_qpform_Pu->p = (c_int*) c_malloc((4 + 1) * sizeof(c_int));
data->test_qpform_Pu->p[0] = 0;
data->test_qpform_Pu->p[1] = 1;
data->test_qpform_Pu->p[2] = 3;
data->test_qpform_Pu->p[3] = 6;
data->test_qpform_Pu->p[4] = 10;

data->test_qpform_x = (c_float*) c_malloc(4 * sizeof(c_float));
data->test_qpform_x[0] = 1.52936495277661177461;
data->test_qpform_x[1] = -1.62619813212797215130;
data->test_qpform_x[2] = -0.29152374809668657463;
data->test_qpform_x[3] = -0.31297573601054251569;
data->test_qpform_value = 0.98431377865644820169;

return data;

}

/* function to clean data struct */
void clean_problem_lin_alg_sols_data(lin_alg_sols_data * data){

c_free(data->test_sp_matrix_A->x);
c_free(data->test_sp_matrix_A->i);
c_free(data->test_sp_matrix_A->p);
c_free(data->test_sp_matrix_A);
c_free(data->test_sp_matrix_Adns);
c_free(data->test_vec_ops_v1);
c_free(data->test_vec_ops_v2);
c_free(data->test_vec_ops_add_scaled);
c_free(data->test_vec_ops_ew_reciprocal);
c_free(data->test_vec_ops_ew_max_vec);
c_free(data->test_vec_ops_ew_min_vec);
c_free(data->test_mat_ops_A->x);
c_free(data->test_mat_ops_A->i);
c_free(data->test_mat_ops_A->p);
c_free(data->test_mat_ops_A);
c_free(data->test_mat_ops_d);
c_free(data->test_mat_ops_prem_diag->x);
c_free(data->test_mat_ops_prem_diag->i);
c_free(data->test_mat_ops_prem_diag->p);
c_free(data->test_mat_ops_prem_diag);
c_free(data->test_mat_ops_postm_diag->x);
c_free(data->test_mat_ops_postm_diag->i);
c_free(data->test_mat_ops_postm_diag->p);
c_free(data->test_mat_ops_postm_diag);
c_free(data->test_mat_ops_inf_norm_cols);
c_free(data->test_mat_ops_inf_norm_rows);
c_free(data->test_mat_vec_A->x);
c_free(data->test_mat_vec_A->i);
c_free(data->test_mat_vec_A->p);
c_free(data->test_mat_vec_A);
c_free(data->test_mat_vec_Pu->x);
c_free(data->test_mat_vec_Pu->i);
c_free(data->test_mat_vec_Pu->p);
c_free(data->test_mat_vec_Pu);
c_free(data->test_mat_vec_x);
c_free(data->test_mat_vec_y);
c_free(data->test_mat_vec_Ax);
c_free(data->test_mat_vec_Ax_cum);
c_free(data->test_mat_vec_ATy);
c_free(data->test_mat_vec_ATy_cum);
c_free(data->test_mat_vec_Px);
c_free(data->test_mat_vec_Px_cum);
c_free(data->test_mat_extr_triu_P->x);
c_free(data->test_mat_extr_triu_P->i);
c_free(data->test_mat_extr_triu_P->p);
c_free(data->test_mat_extr_triu_P);
c_free(data->test_mat_extr_triu_Pu->x);
c_free(data->test_mat_extr_triu_Pu->i);
c_free(data->test_mat_extr_triu_Pu->p);
c_free(data->test_mat_extr_triu_Pu);
c_free(data->test_mat_extr_triu_P_inf_norm_cols);
c_free(data->test_qpform_Pu->x);
c_free(data->test_qpform_Pu->i);
c_free(data->test_qpform_Pu->p);
c_free(data->test_qpform_Pu);
c_free(data->test_qpform_x);

c_free(data);

}

#endif
