/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.IMarineOrganism;
import fr.ird.osmose.output.AbstractOutput;
import fr.ird.osmose.output.distribution.AbstractDistribution;
import fr.ird.osmose.output.distribution.DistributionType;

public abstract class AbstractDistribOutput
extends AbstractOutput {
    double[][] values;
    private final AbstractDistribution distrib;

    public AbstractDistribOutput(int rank, AbstractDistribution distrib) {
        super(rank);
        this.distrib = distrib;
        distrib.init();
    }

    @Override
    public void reset() {
        this.values = new double[this.getNSpecies()][this.distrib.getNClass()];
    }

    int getClass(IMarineOrganism school) {
        return this.distrib.getClass(school);
    }

    @Override
    public void write(float time) {
        int nClass = this.distrib.getNClass();
        double[][] array = new double[nClass][this.getNSpecies() + 1];
        for (int iClass = 0; iClass < nClass; ++iClass) {
            array[iClass][0] = this.distrib.getThreshold(iClass);
            for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
                array[iClass][iSpec + 1] = this.values[iSpec][iClass] / (double)this.getRecordFrequency();
            }
        }
        this.writeVariable(time, array);
    }

    @Override
    String[] getHeaders() {
        String[] headers = new String[this.getNSpecies() + 1];
        headers[0] = this.distrib.getType().toString();
        for (int i = 0; i < this.getNSpecies(); ++i) {
            headers[i + 1] = this.getSimulation().getSpecies(i).getName();
        }
        return headers;
    }

    float getClassThreshold(int iClass) {
        return this.distrib.getThreshold(iClass);
    }

    int getNClass() {
        return this.distrib.getNClass();
    }

    DistributionType getType() {
        return this.distrib.getType();
    }
}

