/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.movement;

import fr.ird.osmose.Cell;
import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.movement.AbstractDistribution;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RandomDistribution
extends AbstractDistribution {
    private final Species species;
    private int areaSize;
    private List<Cell> randomMap;
    private int range;

    public RandomDistribution(int rank, Species species) {
        super(rank);
        this.species = species;
    }

    @Override
    public void init() {
        int iSpec = this.species.getIndex();
        if (!this.getConfiguration().isNull("movement.distribution.ncell.sp" + iSpec)) {
            this.areaSize = this.getConfiguration().getInt("movement.distribution.ncell.sp" + iSpec);
        } else {
            this.areaSize = this.getGrid().getNOceanCell();
            this.warning("Could not find parameter movement.distribution.ncell.sp" + iSpec + ". Osmose assumes that schools of " + this.getSpecies(iSpec).getName() + " are distrubuted over the whole domain.");
        }
        this.createRandomMap();
        this.range = !this.getConfiguration().isNull("movement.randomwalk.range.sp" + iSpec) ? this.getConfiguration().getInt("movement.randomwalk.range.sp" + iSpec) : 1;
    }

    @Override
    public void move(School school) {
        if (school.isUnlocated()) {
            school.moveToCell(this.randomDeal(this.randomMap));
        } else {
            school.moveToCell(this.randomDeal(this.getAccessibleCells(school)));
        }
    }

    private void createRandomMap() {
        int nbCasesDispos = this.getGrid().getNOceanCell();
        if (this.areaSize >= nbCasesDispos) {
            this.areaSize = nbCasesDispos;
            this.randomMap = new ArrayList<Cell>(this.areaSize);
            for (int l = 0; l < this.getGrid().get_ny(); ++l) {
                for (int m = 0; m < this.getGrid().get_nx(); ++m) {
                    if (this.getGrid().getCell(l, m).isLand()) continue;
                    this.randomMap.add(this.getGrid().getCell(l, m));
                }
            }
        } else {
            int nCells = this.areaSize;
            this.randomMap = new ArrayList<Cell>(nCells);
            boolean[][] alreadyChoosen = new boolean[this.getGrid().get_ny()][this.getGrid().get_nx()];
            int coordi = (int)Math.round(Math.random() * (double)(this.getGrid().get_nx() - 1));
            int coordj = (int)Math.round(Math.random() * (double)(this.getGrid().get_ny() - 1));
            while (this.getGrid().getCell(coordi, coordj).isLand()) {
                coordi = (int)Math.round(Math.random() * (double)(this.getGrid().get_nx() - 1));
                coordj = (int)Math.round(Math.random() * (double)(this.getGrid().get_ny() - 1));
            }
            this.randomMap.add(this.getGrid().getCell(coordi, coordj));
            alreadyChoosen[coordj][coordi] = true;
            int iFirstSorted = 0;
            int iLastSorted = 0;
            int index = 0;
            while (index < nCells - 1) {
                for (int iCell = iFirstSorted; iCell <= iLastSorted; ++iCell) {
                    ArrayList<Cell> neigbors = this.getGrid().getNeighbourCells(this.randomMap.get(iCell), 1);
                    Iterator<Cell> iter = neigbors.iterator();
                    while (index < nCells - 1 && iter.hasNext()) {
                        Cell cell = iter.next();
                        if (cell.isLand() || alreadyChoosen[cell.get_jgrid()][cell.get_igrid()]) continue;
                        ++index;
                        alreadyChoosen[cell.get_jgrid()][cell.get_igrid()] = true;
                        this.randomMap.add(cell);
                    }
                }
                iFirstSorted = iLastSorted + 1;
                iLastSorted = index;
            }
        }
    }

    Cell randomDeal(List<Cell> cells) {
        int index = (int)Math.round((double)(cells.size() - 1) * Math.random());
        return cells.get(index);
    }

    private List<Cell> getAccessibleCells(School school) {
        Cell cell = school.getCell();
        ArrayList<Cell> accessibleCells = new ArrayList<Cell>();
        for (Cell neighbor : this.getGrid().getNeighbourCells(cell, this.range)) {
            if (neighbor.isLand()) continue;
            accessibleCells.add(neighbor);
        }
        return accessibleCells;
    }
}

