/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.movement;

import fr.ird.osmose.School;
import fr.ird.osmose.process.AbstractProcess;
import fr.ird.osmose.process.movement.AbstractDistribution;
import fr.ird.osmose.process.movement.MapDistribution;
import fr.ird.osmose.process.movement.RandomDistribution;

public class MovementProcess
extends AbstractProcess {
    private AbstractDistribution[] spatialDistribution;

    public MovementProcess(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        int nSpecies = this.getConfiguration().getNSpecies();
        this.spatialDistribution = new AbstractDistribution[nSpecies];
        for (int i = 0; i < nSpecies; ++i) {
            String distributionMethod = this.getConfiguration().getString("movement.distribution.method.sp" + i);
            if (distributionMethod.equalsIgnoreCase("random")) {
                this.spatialDistribution[i] = new RandomDistribution(this.getRank(), this.getSimulation().getSpecies(i));
            } else if (distributionMethod.equalsIgnoreCase("maps")) {
                this.spatialDistribution[i] = new MapDistribution(this.getRank(), this.getSimulation().getSpecies(i));
            } else {
                throw new UnsupportedOperationException("Distribution method is either 'random' or 'maps'");
            }
            this.spatialDistribution[i].init();
        }
    }

    @Override
    public void run() {
        for (School school : this.getSchoolSet()) {
            this.spatialDistribution[school.getSpeciesIndex()].move(school);
        }
        this.getSchoolSet().updateSchoolMap();
    }

    public static enum SpatialDistribution {
        RANDOM,
        MAPS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

