/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality;

import au.com.bytecode.opencsv.CSVReader;
import fr.ird.osmose.Cell;
import fr.ird.osmose.IAggregation;
import fr.ird.osmose.School;
import fr.ird.osmose.process.mortality.AbstractMortality;
import fr.ird.osmose.stage.AccessibilityStage;
import fr.ird.osmose.stage.IStage;
import fr.ird.osmose.stage.PredPreyStage;
import fr.ird.osmose.util.Separator;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PredationMortality
extends AbstractMortality {
    private double[][] predPreySizesMax;
    private double[][] predPreySizesMin;
    private double[] predationRate;
    private double[][][][] accessibilityMatrix;
    private IStage accessStage;
    private IStage predPreyStage;

    public PredationMortality(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        int i;
        int nspec = this.getNSpecies();
        int nPlankton = this.getConfiguration().getNPlankton();
        this.predPreySizesMax = new double[nspec][];
        this.predPreySizesMin = new double[nspec][];
        this.predationRate = new double[nspec];
        for (i = 0; i < nspec; ++i) {
            this.predPreySizesMax[i] = this.getConfiguration().getArrayDouble("predation.predPrey.sizeRatio.max.sp" + i);
            this.predPreySizesMin[i] = this.getConfiguration().getArrayDouble("predation.predPrey.sizeRatio.min.sp" + i);
            this.predationRate[i] = this.getConfiguration().getDouble("predation.ingestion.rate.max.sp" + i);
        }
        this.accessStage = new AccessibilityStage();
        this.accessStage.init();
        this.predPreyStage = new PredPreyStage();
        this.predPreyStage.init();
        if (!this.getConfiguration().isNull("predation.accessibility.file")) {
            String filename = this.getConfiguration().getFile("predation.accessibility.file");
            try {
                CSVReader reader = new CSVReader(new FileReader(filename), Separator.guess(filename).getSeparator());
                List<String[]> lines = reader.readAll();
                int l = 1;
                this.accessibilityMatrix = new double[nspec + nPlankton][][][];
                for (int i2 = 0; i2 < nspec + nPlankton; ++i2) {
                    int nStagePrey = this.accessStage.getNStage(i2);
                    this.accessibilityMatrix[i2] = new double[nStagePrey][][];
                    for (int j = 0; j < nStagePrey; ++j) {
                        String[] line = lines.get(l);
                        int ll = 1;
                        this.accessibilityMatrix[i2][j] = new double[nspec][];
                        for (int k = 0; k < nspec; ++k) {
                            int nStagePred = this.accessStage.getNStage(k);
                            this.accessibilityMatrix[i2][j][k] = new double[nStagePred];
                            for (int m = 0; m < nStagePred; ++m) {
                                double value;
                                this.accessibilityMatrix[i2][j][k][m] = value = Double.valueOf(line[ll]).doubleValue();
                                ++ll;
                            }
                        }
                        ++l;
                    }
                }
                reader.close();
            }
            catch (IOException ex) {
                this.getSimulation().error("Error loading accessibility matrix from file " + filename, ex);
            }
        } else {
            int j;
            for (i = 0; i < nspec; ++i) {
                this.accessibilityMatrix[i] = new double[1][][];
                this.accessibilityMatrix[i][0] = new double[nspec][];
                for (j = 0; j < nspec; ++j) {
                    this.accessibilityMatrix[i][0][j] = new double[]{0.8};
                }
            }
            for (i = nspec; i < nspec + nPlankton; ++i) {
                this.accessibilityMatrix[i] = new double[1][][];
                this.accessibilityMatrix[i][0] = new double[nspec][];
                for (j = 0; j < nspec; ++j) {
                    this.accessibilityMatrix[i][0][j] = new double[]{0.8};
                }
            }
        }
    }

    public double[] computePredation(School predator, List<IAggregation> preys, double[] accessibility, int subdt) {
        double[] preyUpon = new double[preys.size()];
        if (predator.getAgeDt() > 0) {
            double maxBiomassToPredate;
            double[] accessibleBiomass = new double[preys.size()];
            for (int i = 0; i < preys.size(); ++i) {
                accessibleBiomass[i] = accessibility[i] * preys.get(i).getInstantaneousBiomass();
            }
            double biomAccessibleTot = this.sum(accessibleBiomass);
            double biomassToPredate = maxBiomassToPredate = this.getMaxPredationRate(predator) * predator.getInstantaneousBiomass() / (double)subdt;
            if (biomAccessibleTot != 0.0) {
                if (biomAccessibleTot <= biomassToPredate) {
                    biomassToPredate = biomAccessibleTot;
                }
                for (int i = 0; i < preys.size(); ++i) {
                    double ratio = accessibleBiomass[i] / biomAccessibleTot;
                    preyUpon[i] = ratio * biomassToPredate;
                }
                float success = this.computePredSuccessRate(maxBiomassToPredate, this.sum(preyUpon));
                predator.incrementPredSuccessRate(success / (float)subdt);
            }
        }
        return preyUpon;
    }

    public double[] computePredation(School predator, boolean instantaneous, int subdt) {
        double biomassToPredate;
        Cell cell = predator.getCell();
        List<School> schools = this.getSchoolSet().getSchools(predator.getCell());
        int nFish = schools.size();
        int iStepSimu = this.getSimulation().getIndexTimeSimu();
        double[] preyUpon = new double[schools.size() + this.getConfiguration().getNPlankton()];
        if (predator.getAgeDt() == 0) {
            return preyUpon;
        }
        int[] indexPreys = this.findPreys(predator);
        double[] accessibleBiomass = new double[indexPreys.length];
        for (int i = 0; i < indexPreys.length; ++i) {
            School prey = schools.get(indexPreys[i]);
            accessibleBiomass[i] = instantaneous ? this.getAccessibility(predator, prey) * prey.getInstantaneousBiomass() : this.getAccessibility(predator, prey) * prey.getBiomass();
        }
        double biomAccessibleTot = this.sum(accessibleBiomass);
        double[] percentPlankton = this.getPercentPlankton(predator);
        for (int i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
            double tempAccess = this.accessibilityMatrix[this.getConfiguration().getNSpecies() + i][0][predator.getSpeciesIndex()][this.accessStage.getStage(predator)];
            biomAccessibleTot += percentPlankton[i] * tempAccess * this.getSimulation().getPlankton(i).getAccessibleBiomass(cell, iStepSimu);
        }
        double d = biomassToPredate = instantaneous ? this.getMaxPredationRate(predator) * predator.getInstantaneousBiomass() / (double)subdt : this.getMaxPredationRate(predator) * predator.getBiomass() / (double)subdt;
        if (biomAccessibleTot != 0.0) {
            int i;
            if (biomAccessibleTot <= biomassToPredate) {
                biomassToPredate = biomAccessibleTot;
            }
            for (i = 0; i < indexPreys.length; ++i) {
                double ratio = accessibleBiomass[i] / biomAccessibleTot;
                preyUpon[indexPreys[i]] = ratio * biomassToPredate;
            }
            for (i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
                double tempAccess = this.accessibilityMatrix[this.getConfiguration().getNSpecies() + i][0][predator.getSpeciesIndex()][this.accessStage.getStage(predator)];
                double ratio = percentPlankton[i] * tempAccess * this.getSimulation().getPlankton(i).getAccessibleBiomass(cell, iStepSimu) / biomAccessibleTot;
                preyUpon[nFish + i] = ratio * biomassToPredate;
            }
        }
        return preyUpon;
    }

    private double sum(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public double[][] computePredationMatrix(Cell cell, boolean instantaneous, int subdt) {
        List<School> schools = this.getSchoolSet().getSchools(cell);
        double[][] preyUpon = new double[schools.size() + this.getConfiguration().getNPlankton()][schools.size() + this.getConfiguration().getNPlankton()];
        for (int iPred = 0; iPred < schools.size(); ++iPred) {
            preyUpon[iPred] = this.computePredation(schools.get(iPred), instantaneous, subdt);
        }
        return preyUpon;
    }

    public float computePredSuccessRate(double biomassToPredate, double preyedBiomass) {
        return Math.min((float)(preyedBiomass / biomassToPredate), 1.0f);
    }

    private double[] getPercentPlankton(School predator) {
        double[] percentPlankton = new double[this.getConfiguration().getNPlankton()];
        int iPred = predator.getSpeciesIndex();
        int iStage = this.predPreyStage.getStage(predator);
        double preySizeMax = (double)predator.getLength() / this.predPreySizesMax[iPred][iStage];
        double preySizeMin = (double)predator.getLength() / this.predPreySizesMin[iPred][iStage];
        for (int i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
            percentPlankton[i] = preySizeMin > this.getSimulation().getPlankton(i).getSizeMax() || preySizeMax < this.getSimulation().getPlankton(i).getSizeMin() ? 0.0 : this.getSimulation().getPlankton(i).computePercent(preySizeMin, preySizeMax);
        }
        return percentPlankton;
    }

    private int[] findPreys(School predator) {
        int iPred = predator.getSpeciesIndex();
        List<School> schoolsInCell = this.getSchoolSet().getSchools(predator.getCell());
        int iStage = this.predPreyStage.getStage(predator);
        double preySizeMax = (double)predator.getLength() / this.predPreySizesMax[iPred][iStage];
        double preySizeMin = (double)predator.getLength() / this.predPreySizesMin[iPred][iStage];
        ArrayList<Integer> indexPreys = new ArrayList<Integer>();
        for (int iPrey = 0; iPrey < schoolsInCell.size(); ++iPrey) {
            School prey = schoolsInCell.get(iPrey);
            if (prey.equals(predator) || !((double)prey.getLength() >= preySizeMin) || !((double)prey.getLength() < preySizeMax)) continue;
            indexPreys.add(iPrey);
        }
        int[] index = new int[indexPreys.size()];
        for (int iPrey = 0; iPrey < indexPreys.size(); ++iPrey) {
            index[iPrey] = (Integer)indexPreys.get(iPrey);
        }
        return index;
    }

    public double getMaxPredationRate(School predator) {
        return this.predationRate[predator.getSpeciesIndex()] / (double)this.getConfiguration().getNStepYear();
    }

    private double getAccessibility(School predator, School prey) {
        return this.accessibilityMatrix[prey.getSpeciesIndex()][this.accessStage.getStage(prey)][predator.getSpeciesIndex()][this.accessStage.getStage(predator)];
    }

    public double[] getAccessibility(School predator, List<IAggregation> preys) {
        double[] accessibility = new double[preys.size()];
        int iSpecPred = predator.getSpeciesIndex();
        int iPredPreyStage = this.predPreyStage.getStage(predator);
        double preySizeMax = (double)predator.getLength() / this.predPreySizesMax[iSpecPred][iPredPreyStage];
        double preySizeMin = (double)predator.getLength() / this.predPreySizesMin[iSpecPred][iPredPreyStage];
        double[] percentPlankton = this.getPercentPlankton(predator);
        int iStagePred = this.accessStage.getStage(predator);
        for (int iPrey = 0; iPrey < preys.size(); ++iPrey) {
            int iStagePrey;
            int iSpecPrey = preys.get(iPrey).getSpeciesIndex();
            if (preys.get(iPrey) instanceof School) {
                School prey = (School)preys.get(iPrey);
                if (prey.equals(predator) || !((double)prey.getLength() >= preySizeMin) || !((double)prey.getLength() < preySizeMax)) continue;
                iStagePrey = this.accessStage.getStage(prey);
                accessibility[iPrey] = this.accessibilityMatrix[iSpecPrey][iStagePrey][iSpecPred][iStagePred];
                continue;
            }
            iStagePrey = 0;
            accessibility[iPrey] = this.accessibilityMatrix[iSpecPrey][iStagePrey][iSpecPred][iStagePred] * percentPlankton[iSpecPrey - this.getConfiguration().getNSpecies()];
        }
        return accessibility;
    }

    @Override
    public double getRate(School school) {
        throw new UnsupportedOperationException("Predation mortality is handled explicetly in Osmose.");
    }
}

