/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;
import fr.ird.osmose.process.mortality.MortalityCause;

public class YieldNOutput
extends AbstractOutput {
    public double[] yieldN;

    public YieldNOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.yieldN = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int n = school.getSpeciesIndex();
            this.yieldN[n] = this.yieldN[n] + school.getNdead(MortalityCause.FISHING);
        }
    }

    @Override
    public void write(float time) {
        this.writeVariable(time, this.yieldN);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_yieldN_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "cumulative catch (number of fish caught per time step of saving). ex: if time step of saving is the year, then annual catches in fish numbers are saved";
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

