/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.util.SimulationLinker;
import java.io.File;
import java.io.IOException;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class SchoolSetSnapshot
extends SimulationLinker {
    public SchoolSetSnapshot(int rank) {
        super(rank);
    }

    public void makeSnapshot(int iStepSimu) {
        NetcdfFileWriteable nc = this.createNCFile(iStepSimu);
        int nSchool = this.getSchoolSet().size();
        ArrayInt.D1 species = new ArrayInt.D1(nSchool);
        ArrayFloat.D1 x = new ArrayFloat.D1(nSchool);
        ArrayFloat.D1 y = new ArrayFloat.D1(nSchool);
        ArrayDouble.D1 abundance = new ArrayDouble.D1(nSchool);
        ArrayFloat.D1 age = new ArrayFloat.D1(nSchool);
        ArrayFloat.D1 length = new ArrayFloat.D1(nSchool);
        ArrayFloat.D1 weight = new ArrayFloat.D1(nSchool);
        ArrayFloat.D1 trophiclevel = new ArrayFloat.D1(nSchool);
        int s = 0;
        for (School school : this.getSchoolSet()) {
            species.set(s, school.getSpeciesIndex());
            x.set(s, school.getX());
            y.set(s, school.getY());
            abundance.set(s, school.getInstantaneousAbundance());
            age.set(s, (float)school.getAgeDt() / (float)this.getConfiguration().getNStepYear());
            length.set(s, school.getLength());
            weight.set(s, school.getWeight() * 1000000.0f);
            trophiclevel.set(s, school.getTrophicLevel());
            ++s;
        }
        try {
            nc.write("species", species);
            nc.write("x", x);
            nc.write("y", y);
            nc.write("abundance", abundance);
            nc.write("age", age);
            nc.write("length", length);
            nc.write("weight", weight);
            nc.write("trophiclevel", trophiclevel);
            nc.close();
        }
        catch (IOException ex) {
            this.getSimulation().error("Error writing snapshot " + nc.getLocation(), ex);
        }
        catch (InvalidRangeException ex) {
            this.getSimulation().error("Error writing snapshot " + nc.getLocation(), ex);
        }
    }

    private NetcdfFileWriteable createNCFile(int iStepSimu) {
        NetcdfFileWriteable nc = null;
        try {
            nc = NetcdfFileWriteable.createNew("");
            File path = new File(this.getConfiguration().getOutputPathname());
            File file = new File(path, this.getFilename(iStepSimu));
            file.getParentFile().mkdirs();
            nc.setLocation(file.getAbsolutePath());
        }
        catch (IOException ex) {
            this.getSimulation().error("Could not create snapshot file " + nc.getLocation(), ex);
        }
        Dimension nSchool = nc.addDimension("nschool", this.getSchoolSet().size());
        nc.addVariable("species", DataType.INT, new Dimension[]{nSchool});
        nc.addVariableAttribute("species", "units", "scalar");
        nc.addVariableAttribute("species", "description", "index of the species");
        nc.addVariable("x", DataType.FLOAT, new Dimension[]{nSchool});
        nc.addVariableAttribute("x", "units", "scalar");
        nc.addVariableAttribute("x", "description", "x-grid index of the school");
        nc.addVariable("y", DataType.FLOAT, new Dimension[]{nSchool});
        nc.addVariableAttribute("x", "units", "scalar");
        nc.addVariableAttribute("x", "description", "y-grid index of the school");
        nc.addVariable("abundance", DataType.DOUBLE, new Dimension[]{nSchool});
        nc.addVariableAttribute("abundance", "units", "scalar");
        nc.addVariableAttribute("abundance", "description", "number of fish in the school");
        nc.addVariable("age", DataType.FLOAT, new Dimension[]{nSchool});
        nc.addVariableAttribute("age", "units", "year");
        nc.addVariableAttribute("age", "description", "age of the school in year");
        nc.addVariable("length", DataType.FLOAT, new Dimension[]{nSchool});
        nc.addVariableAttribute("length", "units", "cm");
        nc.addVariableAttribute("length", "description", "length of the fish in the school in centimeter");
        nc.addVariable("weight", DataType.FLOAT, new Dimension[]{nSchool});
        nc.addVariableAttribute("weight", "units", "g");
        nc.addVariableAttribute("weight", "description", "weight of the fish in the school in gram");
        nc.addVariable("trophiclevel", DataType.FLOAT, new Dimension[]{nSchool});
        nc.addVariableAttribute("trophiclevel", "units", "scalar");
        nc.addVariableAttribute("trophiclevel", "description", "trophiclevel of the fish in the school");
        nc.addGlobalAttribute("step", String.valueOf(iStepSimu));
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.getConfiguration().getNSpecies(); ++i) {
            str.append(i);
            str.append("=");
            str.append(this.getSimulation().getSpecies(i).getName());
            str.append(" ");
        }
        nc.addGlobalAttribute("species", str.toString());
        try {
            nc.create();
        }
        catch (IOException ex) {
            this.getSimulation().error("Could not create snapshot file " + nc.getLocation(), ex);
        }
        return nc;
    }

    String getFilename(int iStepSimu) {
        StringBuilder filename = new StringBuilder("restart");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_snapshot_step");
        filename.append(iStepSimu);
        filename.append(".nc.");
        filename.append(this.getRank());
        return filename.toString();
    }
}

