/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ltl;

import fr.ird.osmose.Cell;
import fr.ird.osmose.ltl.LTLForcing;
import fr.ird.osmose.util.SimulationLinker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import ucar.nc2.NetcdfFile;

public class LTLFastForcing
extends SimulationLinker
implements LTLForcing {
    private float[][][][] biomass;
    private int nLTLStep;
    private int iLTLStep;

    public LTLFastForcing(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        String ncFile = this.getConfiguration().getFile("ltl.netcdf.file");
        if (!new File(ncFile).exists()) {
            this.error("Error reading LTLForcing parameters.", new FileNotFoundException("LTL NetCDF file " + ncFile + " does not exist."));
        }
        this.nLTLStep = this.getConfiguration().getInt("ltl.nstep");
        this.iLTLStep = 0;
        this.loadData(ncFile);
    }

    private void loadData(String ncFile) {
        try {
            this.info("Loading plankton data...");
            this.debug("Forcing file {0}", ncFile);
            NetcdfFile nc = NetcdfFile.open(ncFile);
            this.biomass = (float[][][][])nc.findVariable("ltl_biomass").read().copyToNDJavaArray();
        }
        catch (IOException ex) {
            this.error("Error while loading LTL biomass from file " + ncFile, ex);
        }
    }

    @Override
    public double getBiomass(int iPlankton, Cell cell) {
        return this.biomass[this.iLTLStep][iPlankton][cell.get_jgrid()][cell.get_igrid()];
    }

    @Override
    public void update(int iStepSimu) {
        this.iLTLStep = this.getSimulation().getIndexTimeSimu() % this.nLTLStep;
    }
}

