/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.IAggregation;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.Prey;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.mortality.MortalityCause;
import fr.ird.osmose.util.GridPoint;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;

public class School
extends GridPoint
implements IAggregation {
    private final Species species;
    private final int index;
    private float weight;
    private float trophicLevel;
    private double abundance;
    private double instantaneousAbundance;
    private final double[] nDead = new double[MortalityCause.values().length];
    private boolean abundanceHasChanged;
    private double eggRetained;
    private int ageDt;
    private float age;
    private float length;
    private float lengthi;
    private final HashMap<Integer, Prey> preys;
    private double preyedBiomass;
    private float predSuccessRate;
    private double starvationRate;
    private boolean out;
    private double[] accessibility;
    private final UUID uuid = UUID.randomUUID();

    public School(Species species, double abundance) {
        this(species, abundance, species.getEggSize(), species.getEggWeight(), 0);
    }

    public School(Species species, double abundance, float length, float weight, int age) {
        this(species, -1.0f, -1.0f, abundance, length, weight, age, 3.0f);
    }

    public School(Species species, float x, float y, double abundance, float length, float weight, int ageDt, float trophicLevel) {
        this.index = species.getIndex();
        this.abundance = abundance;
        this.instantaneousAbundance = abundance;
        this.weight = weight * 1.0E-6f;
        this.trophicLevel = trophicLevel;
        if (x >= 0.0f && x < (float)School.getGrid().get_nx() && y >= 0.0f && y < (float)School.getGrid().get_ny()) {
            this.moveToCell(School.getGrid().getCell(Math.round(x), Math.round(y)));
        } else {
            this.setOffGrid();
        }
        this.eggRetained = 0.0;
        this.species = species;
        this.length = length;
        this.ageDt = ageDt;
        this.age = (float)ageDt / (float)this.getConfiguration().getNStepYear();
        this.out = false;
        this.preys = new HashMap();
        this.starvationRate = 0.0;
    }

    public void init() {
        this.updateAbundance();
        this.preys.clear();
        this.preyedBiomass = 0.0;
        this.predSuccessRate = 0.0f;
        this.out = false;
        this.lengthi = this.length;
    }

    public void releaseEgg(int subdt) {
        this.eggRetained = Math.max(0.0, this.eggRetained - (this.abundance - this.nDead[MortalityCause.ADDITIONAL.index]) / (double)subdt);
        this.abundanceHasChanged = true;
    }

    public void retainEgg() {
        this.eggRetained = this.abundance - this.nDead[MortalityCause.ADDITIONAL.index];
        this.abundanceHasChanged = true;
    }

    @Override
    public double getAbundance() {
        return this.abundance;
    }

    @Override
    public double getInstantaneousAbundance() {
        if (this.abundanceHasChanged) {
            this.instantaneousAbundance = this.abundance - this.eggRetained - this.sum(this.nDead);
            if (this.instantaneousAbundance < 1.0) {
                this.instantaneousAbundance = 0.0;
            }
            this.abundanceHasChanged = false;
        }
        return this.instantaneousAbundance;
    }

    public void updateAbundance() {
        this.abundance = this.getInstantaneousAbundance();
        this.reset(this.nDead);
        this.abundanceHasChanged = false;
    }

    @Override
    public double getBiomass() {
        return this.adb2biom(this.abundance);
    }

    @Override
    public double getInstantaneousBiomass() {
        return this.adb2biom(this.getInstantaneousAbundance());
    }

    @Override
    public double biom2abd(double biomass) {
        return biomass / (double)this.weight;
    }

    public double adb2biom(double abundance) {
        return abundance * (double)this.weight;
    }

    @Override
    public float getTrophicLevel() {
        return this.trophicLevel;
    }

    public void setTrophicLevel(float trophicLevel) {
        this.trophicLevel = trophicLevel;
    }

    @Override
    public int getSpeciesIndex() {
        return this.index;
    }

    public double getNdead(MortalityCause cause) {
        return this.nDead[cause.index];
    }

    public void setNdead(MortalityCause cause, double nDead) {
        this.nDead[cause.index] = nDead;
        this.abundanceHasChanged = true;
    }

    @Override
    public void incrementNdead(MortalityCause cause, double nDead) {
        int n = cause.index;
        this.nDead[n] = this.nDead[n] + nDead;
        this.abundanceHasChanged = true;
    }

    public void resetNdead(MortalityCause cause) {
        this.nDead[cause.index] = 0.0;
        this.abundanceHasChanged = true;
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    private double sum(double[] array) {
        double sum = 0.0;
        for (double d : array) {
            sum += d;
        }
        return sum;
    }

    private void reset(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0.0;
        }
    }

    public void preyedUpon(int indexPrey, float trophicLevel, float age, float length, double preyedBiomass, boolean keepRecord) {
        if (keepRecord) {
            Prey prey = new Prey(indexPrey, trophicLevel, age, length, preyedBiomass);
            int hash = prey.hashCode();
            if (this.preys.containsKey(hash)) {
                this.preys.get(hash).incrementBiomass(prey.getBiomass());
            } else {
                this.preys.put(prey.hashCode(), prey);
            }
        }
        this.preyedBiomass += preyedBiomass;
    }

    public Collection<Prey> getPreys() {
        return this.preys.values();
    }

    public void out() {
        this.out = true;
        this.setOffGrid();
    }

    public boolean isOut() {
        return this.out;
    }

    public boolean isAlive() {
        return this.getInstantaneousAbundance() > 0.0 && this.ageDt <= this.species.getLifespanDt() - 1;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("School");
        str.append("\n  Species: ");
        str.append(this.getSpecies().getName());
        str.append("\n  Cohort: ");
        str.append(this.getAge());
        str.append(" [year]");
        str.append("\n  Cell: ");
        str.append(this.getCell().getIndex());
        return str.toString();
    }

    public Species getSpecies() {
        return this.species;
    }

    public int getAgeDt() {
        return this.ageDt;
    }

    @Override
    public float getAge() {
        return this.age;
    }

    public void incrementAge() {
        ++this.ageDt;
        this.age = (float)this.ageDt / (float)this.getConfiguration().getNStepYear();
    }

    @Override
    public float getLength() {
        return this.length;
    }

    public void incrementLength(float dlength) {
        if (dlength != 0.0f) {
            this.length += dlength;
            this.setWeight(this.species.computeWeight(this.length) * 1.0E-6f);
        }
    }

    private Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        School other = (School)obj;
        return this.uuid.equals(other.uuid);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this.uuid.hashCode();
        return hash;
    }

    public double getPreyedBiomass() {
        return this.preyedBiomass;
    }

    public float getPredSuccessRate() {
        return this.predSuccessRate;
    }

    public void setPredSuccessRate(float rate) {
        this.predSuccessRate = rate;
    }

    public void incrementPredSuccessRate(float drate) {
        this.predSuccessRate += drate;
    }

    public double getStarvationRate() {
        return this.starvationRate;
    }

    public void setStarvationRate(double starvationRate) {
        this.starvationRate = starvationRate;
    }

    public float getLengthIniStep() {
        return this.lengthi;
    }

    public void setAccessibility(double[] accessibility) {
        this.accessibility = accessibility;
    }

    public double[] getAccessibility() {
        return this.accessibility;
    }
}

