% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm_status_notes.R
\name{osm_close_note}
\alias{osm_close_note}
\alias{osm_reopen_note}
\title{Close or reopen notes}
\usage{
osm_close_note(note_id)

osm_reopen_note(note_id)
}
\arguments{
\item{note_id}{Note ids represented by a numeric or character vector.}
}
\value{
Returns a data frame with the closed map notes (same format as \code{\link[=osm_get_notes]{osm_get_notes()}} with \code{format = "R"}).
}
\description{
Requires authentication.
}
\section{Functions}{
\itemize{
\item \code{osm_close_note()}: Close notes as fixed.

\item \code{osm_reopen_note()}: Reopen closed notes.

}}
\examples{
\dontrun{
set_osmapi_connection("testing") # use the testing server
note <- osm_create_note(lat = 41.38373, lon = 2.18233, text = "Testing osmapiR")
closed_note <- osm_close_note(note$id)
closed_note
reopened_note <- osm_reopen_note(note$id)
reopened_note
closed_note <- osm_close_note(note$id) # leave it closed
}
}
\seealso{
Other edit notes' functions: 
\code{\link{osm_create_comment_note}()},
\code{\link{osm_create_note}()},
\code{\link{osm_delete_note}()}
}
\concept{edit notes' functions}
