\name{laguerre.recurrences}
\alias{laguerre.recurrences}
\title{ Recurrence relations for Laguerre polynomials }
\description{
  This function returns a data frame with $n$+1 rows and four named columns containing the coefficient vectors \bold{c}, \bold{d}, \bold{e} and \bold{f} of the recurrence relations for the order $k$ Laguerre polynomial, \eqn{L_n \left( x \right)}, and for orders $k$ = 0, 1, ... , $n$.
}
\usage{
laguerre.recurrences(n, normalized=FALSE)
}
\arguments{
  \item{n}{ integer highest polynomial order }
  \item{normalized}{ boolean value which, if TRUE, returns recurrence relations for normalized polynomials }
}
\value{
  A data frame with the recurrence relation parameters.
}
\references{ Abramowitz and Stegun (1968) }
\author{ Frederick Novomestky \email{fnovomes@poly.edu} }
\seealso{
\code{\link{glaguerre.recurrences}},
}
\examples{
normalized.r <- laguerre.recurrences( 10, normalized=TRUE )
unnormalized.r <- laguerre.recurrences( 10, normalized=FALSE )
}
\keyword{ math }
