% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blend.R
\docType{methods}
\name{blend}
\alias{blend}
\alias{blendVolumes}
\alias{blend,nifti,nifti-method}
\alias{blend,nifti,nifti-methods}
\alias{blend,anlz,anlz-method}
\alias{blend,anlz,anlz-methods}
\alias{blend,anlz,nifti-method}
\alias{blend,anlz,nifti-methods}
\alias{blend,nifti,anlz-method}
\alias{blend,nifti,anlz-methods}
\title{Merge Two NIfTI or ANALYZE Volumes}
\usage{
blendVolumes(x, y, seqX, seqY, method = "linear")

\S4method{blend}{nifti,nifti}(x, y, seqX, seqY, method = "linear")

\S4method{blend}{anlz,anlz}(x, y, seqX, seqY, method = "linear")

\S4method{blend}{anlz,nifti}(x, y, seqX, seqY, method = "linear")

\S4method{blend}{nifti,anlz}(x, y, seqX, seqY, method = "linear")
}
\arguments{
\item{x, y}{are objects of class \code{nifti} or \code{anlz}.}

\item{seqX, seqY}{are vectors that provide the $z$-coordinate values for the 
two imaging volumes.}

\item{method}{is the type of weighing to use when combining information where 
there is an overlap (default = \code{"linear"}).}
}
\value{
A single volume that blends the voxel-wise information from \code{x} 
and \code{y}.
}
\description{
Two volumes of medical imaging data are merged together in the 
superior-inferior (or $z$) direction.  One assumes that there is at least one
slice that overlaps between the two volumes.
}
\section{Methods}{
 
\describe{ 
\item{x = "nifti", y = "nifti"}{Merge \code{x} and \code{y}.} 
\item{x = "anlz", y = "anlz"}{Merge \code{x} on \code{y}.} 
\item{x = "nifti", y = "anlz"}{Merge \code{x} on \code{y}.} 
\item{x = "anlz", y = "nifti"}{Merge \code{x} and \code{y}.} 
}
}

\seealso{
\code{\link{image-methods}}, \code{\link{overlay-methods}}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\keyword{methods}
