% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_funs.R
\name{linear_total_cost}
\alias{linear_total_cost}
\title{Compute total cost as a linear function of time}
\usage{
linear_total_cost(time, recruits, int, beta, rec_exp = 1)
}
\arguments{
\item{time}{The amount of time that fish are raised in hatchery}

\item{recruits}{The number of recruits raised}

\item{int}{Intercept for the linear total cost curve}

\item{beta}{Slope for the linear total cost curve}

\item{rec_exp}{The exponent on the number of recruits}
}
\value{
A vector the same length as \code{time} with the total cost to raise
n \code{recruits} to \code{time}
}
\description{
This function returns the total cost of raising n \code{recruits} to
\code{time}. The curve across \code{time} can only be linear
with parameters \code{int} and \code{beta}, but can be non-linear with
respect to \code{recruits}
}
\examples{
curve(linear_total_cost(x, 0.5, 0.001, 100), 0, 1000)
}
