% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/batch_opt.R
\name{get.var}
\alias{get.var}
\title{Internal function. With stratified samples, calculate the variance of the estimate from importance sampling without control variates}
\usage{
get.var(Y, nvec)
}
\arguments{
\item{Y}{vector of stratified samples of length \eqn{n}. i.e. \eqn{Y_1 = Y[1:nvec[1]]} are sampled from \eqn{q_1}, \eqn{Y_i = Y[(nvec[i-1]+1):nvec[i]]} are sample from \eqn{q_i}.}

\item{nvec}{the vector of number of samples from each mixture component. It sums up to \eqn{n}.}
}
\value{
the variance estimate of \eqn{\hat{\mu} = 1/n \sum_{i=1}^n Y[i]}
}
\description{
Internal function. With stratified samples, calculate the variance of the estimate from importance sampling without control variates
}
\details{
Suppose we sample Y from a mixture \eqn{q_{\alpha} = \alpha_1*q_1 + ... + \alpha_J*q_J}. To estimate \eqn{\mathrm{mean}(Y)}, fixing the number of samples from each mixture component and getting a stratified sample would reduce the variance of the estimate. The formula for \eqn{\mathrm{Var}(\hat{\mu})} with stratified samples is \deqn{\mathrm{Var}(\hat{\mu}) = 1/n \times \sum_{j=1}^J \alpha_j \mathrm{Var}(Y_j)}
}

