% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.optint_by_group}
\alias{plot.optint_by_group}
\title{Plot optint object, by group}
\usage{
\method{plot}{optint_by_group}(x, plot.vars = "sig", graph.col = NULL,
  alpha = 0.05, ...)
}
\arguments{
\item{x}{an optint_by_group object.}

\item{plot.vars}{which variables to plot? either a number (n) -
indicating to plot the first n variables,
"sig" (default) - plot only significant variables
(here significant means that variabe is signifcant for
all groups, or that there is significant heterogeneity),
or a vector with names of variables to plot.}

\item{graph.col}{graph color/s.}

\item{alpha}{significance level for the confidence intervals. also
used in order to determine which variables are significant.}

\item{...}{additional arguments.}
}
\description{
Produce variables importance plot from an optint_by_group object.
This plot has several features:
\describe{
  \item{1.}{Estimates here are \eqn{E(X | I=1) - E(X | I=0)} and not cdf distances.}
  \item{2.}{Star is added to variable name if there is a
            significant difference between at least two groups.}
  \item{3.}{Estimates are standardized before they plotted (so different set of variables
            will have different standardization factor.)}}
}
