% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seriesToBlock.R
\name{seriesToBlock}
\alias{seriesToBlock}
\alias{blockToSeries}
\title{Convert a 1-dimensional series to blocks}
\usage{
seriesToBlock(X, d)

blockToSeries(X)
}
\arguments{
\item{X}{An array or a vector to be converted.}

\item{d}{A positive integer defining the block size.}
}
\description{
The functions \code{seriesToBlock} and \code{blockToSeries} convert 1-dimensional series into series of higher dimension.
For instance, suppose you have a time-series that consists of \eqn{T = 100} days of \eqn{d = 24} hours. 
The function seriesToBlock converts the time-series X of \eqn{Td = 2400} observations into a matrix of size \code{c(T=100,d =24)}, 
where each line corresponds to a specific day. This function is usefull if you need to perform the prediction day by day, instead of hour by hour.
The function can also be used to convert a matrix of expert prediction of dimension \code{c(dT,K)} where K is the number of experts,
into an array of dimension \code{c(T,d,K)}. The new arrays of observations and of expert predictions can be
given to the aggregation rule procedure to perform \code{d}-dimensional predictions (i.e., day predictions).
}
\details{
The function blockToSeries performs the inverse operation.
}
