% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_filter}
\alias{wb_filter}
\alias{wb_add_filter}
\alias{wb_remove_filter}
\title{Add/remove column filters in a worksheet}
\usage{
wb_add_filter(wb, sheet = current_sheet(), rows, cols)

wb_remove_filter(wb, sheet = current_sheet())
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A worksheet name or index.
In \code{wb_remove_filter()}, you may supply a vector of worksheets.}

\item{rows}{A row number.}

\item{cols}{columns to add filter to.}
}
\description{
Add or remove excel column filters to a worksheet
}
\details{
Adds filters to worksheet columns, same as \code{with_filter = TRUE} in \code{\link[=wb_add_data]{wb_add_data()}}
\code{\link[=wb_add_data_table]{wb_add_data_table()}} automatically adds filters to first row of a table.

NOTE Can only have a single filter per worksheet unless using tables.
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2")
wb$add_worksheet("Sheet 3")

wb$add_data(1, iris)
wb$add_filter(1, row = 1, cols = seq_along(iris))

## Equivalently
wb$add_data(2, x = iris, withFilter = TRUE)

## Similarly
wb$add_data_table(3, iris)
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2")
wb$add_worksheet("Sheet 3")

wb$add_data(1, iris)
wb_add_filter(wb, 1, row = 1, cols = seq_along(iris))

## Equivalently
wb$add_data(2, x = iris, withFilter = TRUE)

## Similarly
wb$add_data_table(3, iris)

## remove filters
wb_remove_filter(wb, 1:2) ## remove filters
wb_remove_filter(wb, 3) ## Does not affect tables!
}
\seealso{
\code{\link[=wb_add_data]{wb_add_data()}}, \code{\link[=wb_add_data_table]{wb_add_data_table()}}
}
