% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_functions.R
\name{wb_add_mschart}
\alias{wb_add_mschart}
\title{dummy function to add a chart to an existing workbook
currently only a barplot is possible}
\usage{
wb_add_mschart(wb, sheet = current_sheet(), dims = "B2:H8", graph)
}
\arguments{
\item{wb}{a workbook}

\item{sheet}{the sheet on which the graph will appear}

\item{dims}{the dimensions where the sheet will appear}

\item{graph}{mschart graph}
}
\description{
dummy function to add a chart to an existing workbook
currently only a barplot is possible
}
\examples{
if (requireNamespace("mschart")) {
require(mschart)

## Add mschart to worksheet (adds data and chart)
scatter <- ms_scatterchart(data = iris, x = "Sepal.Length", y = "Sepal.Width", group = "Species")
scatter <- chart_settings(scatter, scatterstyle = "marker")

wb <- wb_workbook() \%>\%
 wb_add_worksheet() \%>\%
 wb_add_mschart(dims = "F4:L20", graph = scatter)

## Add mschart to worksheet and use available data
wb <- wb_workbook() \%>\%
  wb_add_worksheet() \%>\%
  wb_add_data(x = mtcars, dims = "B2")

# create wb_data object
dat <- wb_data(wb, 1, dims = "B2:E6")

# call ms_scatterplot
data_plot <- ms_scatterchart(
  data = dat,
  x = "mpg",
  y = c("disp", "hp"),
  labels = c("disp", "hp")
)

# add the scatterplot to the data
wb <- wb \%>\%
  wb_add_mschart(dims = "F4:L20", graph = data_plot)
}
}
\seealso{
\code{\link[=wb_data]{wb_data()}}
}
