% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_freeze_pane}
\alias{wb_freeze_pane}
\title{Freeze a worksheet pane}
\usage{
wb_freeze_pane(
  wb,
  sheet = current_sheet(),
  firstActiveRow = NULL,
  firstActiveCol = NULL,
  firstRow = FALSE,
  firstCol = FALSE
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{firstActiveRow}{Top row of active region}

\item{firstActiveCol}{Furthest left column of active region}

\item{firstRow}{If \code{TRUE}, freezes the first row (equivalent to firstActiveRow = 2)}

\item{firstCol}{If \code{TRUE}, freezes the first column (equivalent to firstActiveCol = 2)}
}
\description{
Freeze a worksheet pane
}
\examples{
## Create a new workbook
wb <- wb_workbook("Kenshin")

## Add some worksheets
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2")
wb$add_worksheet("Sheet 3")
wb$add_worksheet("Sheet 4")

## Freeze Panes
wb$freeze_pane("Sheet 1", firstActiveRow = 5, firstActiveCol = 3)
wb$freeze_pane("Sheet 2", firstCol = TRUE) ## shortcut to firstActiveCol = 2
wb$freeze_pane(3, firstRow = TRUE) ## shortcut to firstActiveRow = 2
wb$freeze_pane(4, firstActiveRow = 1, firstActiveCol = "D")
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
