% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loadWorkbook.R
\name{loadWorkbook}
\alias{loadWorkbook}
\title{Load an exisiting .xlsx file}
\usage{
loadWorkbook(file, xlsxFile = NULL)
}
\arguments{
\item{file}{A path to an existing .xlsx or .xlsm file}

\item{xlsxFile}{alias for file}
}
\value{
Workbook object.
}
\description{
loadWorkbook returns a workbook object conserving styles and
formatting of the original .xlsx file.
}
\examples{
## load existing workbook from package folder
wb <- loadWorkbook(file = system.file("loadExample.xlsx", package= "openxlsx"))
names(wb)  #list worksheets
wb ## view object
## Add a worksheet
addWorksheet(wb, "A new worksheet")

## Save workbook
saveWorkbook(wb, "loadExample.xlsx", overwrite = TRUE)
}
\author{
Alexander Walker
}
\seealso{
\code{\link{removeWorksheet}}
}

