% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signing.R
\name{signature_create}
\alias{signature_create}
\alias{signature_verify}
\title{Signatures}
\usage{
signature_create(data, hash = sha1, key = my_key(), password = readline)

signature_verify(data, sig, hash = sha1, pubkey = my_pubkey())
}
\arguments{
\item{data}{raw data vector or file path for message to be signed.
If \code{hash == NULL} then \code{data} must be a hash string or raw vector.}

\item{hash}{the digest function to use. Must be one of \code{\link{md5}},
\code{\link{sha1}}, \code{\link{sha256}}, \code{\link{sha512}} or \code{NULL}.}

\item{key}{private key or file path. See \code{\link{read_key}}.}

\item{password}{string or a function to read protected keys. See \code{\link{read_key}}.}

\item{sig}{raw vector or file path for the signature data.}

\item{pubkey}{public key or file path. See \code{\link{read_pubkey}}.}
}
\description{
Sign and verify a message digest. RSA supports both MD5 and SHA signatures
whereas DSA and EC keys only support SHA.
}
\examples{
# Generate a keypair
key <- rsa_keygen()
pubkey <- as.list(key)$pubkey

# Sign a file
data <- system.file("DESCRIPTION")
sig <- signature_create(data, key = key)
stopifnot(signature_verify(data, sig, pubkey = pubkey))

# Sign raw data
data <- serialize(iris, NULL)
sig <- signature_create(data, sha256, key = key)
stopifnot(signature_verify(data, sig, sha256, pubkey = pubkey))

# Sign a hash
md <- md5(data)
sig <- signature_create(md, hash = NULL, key = key)
stopifnot(signature_verify(md, sig, hash = NULL, pubkey = pubkey))
}

