% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-nyc_marathon.R
\docType{data}
\name{nyc_marathon}
\alias{nyc_marathon}
\title{New York City Marathon Times}
\format{
A data frame with 102 observations on the following 7 variables.
\describe{
\item{year}{Year of marathom.}
\item{name}{Name of winner.}
\item{country}{Country of winner.}
\item{time}{Running time (HH:MM:SS).}
\item{time_hrs}{Running time (in hours).}
\item{division}{Division: \code{Men} or \code{Women}.}
\item{note}{Note about the race or the winning time.}
}
}
\source{
Wikipedia, \href{https://en.wikipedia.org/wiki/List_of_winners_of_the_New_York_City_Marathon}{List of winners of the New York City Marathon}. Retrieved 28 April, 2021.
}
\usage{
nyc_marathon
}
\description{
Marathon times of runners in the Men and Women divisions of the New York
City Marathon, 1970 - 2020.
}
\examples{
library(ggplot2)

ggplot(nyc_marathon, aes(x = year, y = time_hrs, color = division, shape = division)) +
  geom_point()
}
\keyword{datasets}
