% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-openintro.R
\name{scale_color_openintro}
\alias{scale_color_openintro}
\title{Color scale constructor for OpenIntro IMS colors}
\usage{
scale_color_openintro(palette = "main", discrete = TRUE, reverse = FALSE, ...)
}
\arguments{
\item{palette}{Character name of palette in \link{openintro_palettes}}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not}

\item{reverse}{Boolean indicating whether the palette should be reversed}

\item{...}{Additional arguments passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}} or
\code{\link[ggplot2:scale_gradient]{ggplot2::scale_color_gradientn()}}, used respectively when discrete is TRUE or FALSE}
}
\description{
Color scale constructor for OpenIntro IMS colors
}
\examples{

library(ggplot2)

# Categorical variable with three levels
ggplot(evals, aes(x = bty_avg, y = score,
                      color = rank, shape = rank)) +
  geom_jitter(size = 2, alpha = 0.6) +
  scale_color_openintro("three")

# Categorical variable with two levels
ggplot(evals, aes(x = bty_avg, y = score,
                  color = language, shape = language)) +
  geom_jitter(size = 2, alpha = 0.6) +
  scale_color_openintro("two")

# Continuous variable
# Generates a palette, but not recommended
ggplot(evals, aes(x = bty_avg, y = score,
                  color = score)) +
  geom_jitter(size = 2, alpha = 0.8) +
  scale_color_openintro(discrete = FALSE)

# For continous palettes
# use scale_color_gradient instead
ggplot(evals, aes(x = bty_avg, y = score,
                  color = score)) +
  geom_jitter(size = 2) +
  scale_color_gradient(low = IMSCOL["blue", "full"], high = IMSCOL["blue", "f6"])

ggplot(evals, aes(x = bty_avg, y = score,
                  color = cls_perc_eval)) +
  geom_jitter(size = 2) +
  scale_color_gradient(low = COL["red", "full"], high = COL["red", "f8"])

}
