% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxPlot.R
\name{boxPlot}
\alias{boxPlot}
\title{Box plot}
\usage{
boxPlot(
  x,
  fact = NULL,
  horiz = FALSE,
  width = 2/3,
  lwd = 1,
  lcol = "black",
  medianLwd = 2,
  pch = 20,
  pchCex = 1.8,
  col = grDevices::rgb(0, 0, 0, 0.25),
  add = FALSE,
  key = NULL,
  axes = TRUE,
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{x}{A numerical vector.}

\item{fact}{A character or factor vector defining the grouping for
side-by-side box plots.}

\item{horiz}{If \code{TRUE}, the box plot is oriented horizontally.}

\item{width}{The width of the boxes in the plot. Value between \code{0} and
\code{1}.}

\item{lwd}{Width of lines used in box and whiskers.}

\item{lcol}{Color of the box, median, and whiskers.}

\item{medianLwd}{Width of the line marking the median.}

\item{pch}{Plotting character of outliers.}

\item{pchCex}{Size of outlier character.}

\item{col}{Color of outliers.}

\item{add}{If \code{FALSE}, a new plot is created. Otherwise, the boxplots
are added to the current plot for values of \code{TRUE} or a numerical
vector specifying the locations of the boxes.}

\item{key}{The order in which to display the side-by-side boxplots. If
locations are specified in \code{add}, then the elements of \code{add} will
correspond to the elements of \code{key}.}

\item{axes}{Whether to plot the axes.}

\item{xlab}{Label for the x axis.}

\item{ylab}{Label for the y axis.}

\item{xlim}{Limits for the x axis.}

\item{ylim}{Limits for the y axis.}

\item{na.rm}{Indicate whether \code{NA} values should be removed.}

\item{\dots}{Additional arguments to plot.}
}
\description{
An alternative to \code{boxplot}. Equations are not accepted. Instead, the
second argument, \code{fact}, is used to split the data.
}
\examples{

# univariarate
boxPlot(email$num_char, ylab = "Number of characters in emails")

# bivariate
boxPlot(email$num_char, email$spam,
        xlab = "Spam",
        ylab = "Number of characters in emails")

# faded outliers
boxPlot(email$num_char, email$spam,
        xlab = "Spam",
        ylab = "Number of characters in emails",
        col = fadeColor("black", 18))

# horizontal plots
boxPlot(email$num_char, email$spam,
        horiz = TRUE,
        xlab = "Spam",
        ylab = "Number of characters in emails",
        col = fadeColor("black", 18))

# bivariate relationships where categorical data have more than 2 levels
boxPlot(email$num_char, email$image,
        horiz = TRUE,
        xlab = "Number of attached images",
        ylab = "Number of characters in emails",
        col = fadeColor("black", 18))

# key can be used to restrict to only the desired groups
boxPlot(email$num_char, email$image,
        horiz = TRUE, key = c(0, 1, 2),
        xlab = "Number of attached images (limited to 0, 1, 2)",
        ylab = "Number of characters in emails",
        col = fadeColor("black", 18))

# combine boxPlot and dotPlot
boxPlot(tips$tip, tips$day,
        horiz = TRUE, key = c("Tuesday", "Friday"))
dotPlot(tips$tip, tips$day,
        add=TRUE, at = 1:2+0.05,
        key=c("Tuesday", "Friday"))

# adding a box
par(mfrow=1:2)
boxPlot(email$num_char[email$spam==0], xlim = c(0,3))
boxPlot(email$num_char[email$spam==1], add = 2, axes = FALSE)
axis(1, at = 1:2, labels = c(0, 1))
boxPlot(email$num_char[email$spam==0], ylim = c(0,3), horiz = TRUE)
boxPlot(email$num_char[email$spam==1], add = 2, horiz = TRUE, axes = FALSE)
axis(2, at = 1:2, labels = c(0, 1))

}
\seealso{
\code{\link{histPlot}}, \code{\link{dotPlot}},
\code{\link{densityPlot}}
}
\author{
David Diez
}
