% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_series_metadata.R
\name{oc_series_metadata}
\alias{oc_series_metadata}
\title{Query Opencast for a specific series metadata}
\usage{
oc_series_metadata(seriesId = "", type = "")
}
\arguments{
\item{seriesId}{The event id}

\item{type}{The type of metadata to get}
}
\value{
Returns a series' metadata of all types or returns a series' metadata collection of the given type when the query string parameter type is specified.
}
\description{
Returns a series' metadata of all types or returns a series' metadata collection of the given type when the query string parameter type is specified.
}
\details{
This function expects the hostname, username and password to be set as environment variables.
}
\examples{
Sys.setenv(OPENCAST_HOST = "https://legacy.opencast.org")
Sys.setenv(OPENCAST_USERNAME = "admin")
Sys.setenv(OPENCAST_PASSWORD = "opencast")

series <- oc_list_series()

oc_series_metadata(series$content$identifier[1])
}
