% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traj_trajMap.R
\name{trajMapStatic}
\alias{trajMapStatic}
\title{Trajectory line plots in \code{ggplot2}}
\usage{
trajMapStatic(
  data,
  colour = "height",
  type = NULL,
  group = NULL,
  longitude = "lon",
  latitude = "lat",
  npoints = 12,
  xlim = NULL,
  ylim = NULL,
  crs = sf::st_crs(3812),
  origin = TRUE,
  map = TRUE,
  map.fill = "grey85",
  map.colour = "grey75",
  map.alpha = 0.8,
  map.lwd = 0.5,
  map.lty = 1,
  facet = NULL,
  ...
)
}
\arguments{
\item{data}{\emph{A data frame containing a HYSPLIT trajectory, perhaps accessed
with \code{\link[openair:importTraj]{openair::importTraj()}}.}

\strong{required}

A data frame containing HYSPLIT model outputs. If this data were not
obtained using \code{\link[openair:importTraj]{openair::importTraj()}}.}

\item{colour}{\emph{Column to be used for colouring each trajectory.}

\emph{default:} \code{NULL}

This column may be numeric, character, factor or date(time). This will
commonly be a pollutant concentration which has been joined (e.g., by
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}}) to the trajectory data by "date".}

\item{type}{\emph{A method to condition the \code{data} for separate plotting.}

\emph{default:} \code{NULL}

Used for splitting the trajectories into different groups which will appear
as different panels. Passed to \code{\link[openair:cutData]{openair::cutData()}}.}

\item{group}{\emph{Column to use to distinguish different trajectory paths.}

\emph{default:} \code{NULL}

By default, trajectory paths are distinguished using the arrival date.
\code{group} allows for additional columns to be used (e.g., \code{"receptor"} if
multiple receptors are being plotted).}

\item{latitude, longitude}{\emph{The decimal latitude/longitude.}

\emph{default:} \code{"lat"} / \code{"lon"}

Column names representing the decimal latitude and longitude.}

\item{npoints}{\emph{Interval at which points are placed along the trajectory
paths.}

\emph{default:} \code{12}

A dot is placed every \code{npoints} along each full trajectory. For hourly back
trajectories points are plotted every \code{npoints} hours. This helps to
understand where the air masses were at particular times and get a feel for
the speed of the air (points closer together correspond to slower moving
air masses). Defaults to \code{12}.}

\item{xlim, ylim}{\emph{The x- and y-limits of the plot.}

\emph{default:} \code{NULL}

A numeric vector of length two defining the x-/y-limits of the map, passed
to \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}}. If \code{NULL}, limits will be estimated based on the
lat/lon ranges of the input data.}

\item{crs}{\emph{The coordinate reference system (CRS) into which all data should
be projected before plotting.}

\emph{default:} \code{sf::st_crs(3812)}

This argument defaults to the Lambert projection, but can take any
coordinate reference system to pass to the \code{crs} argument of
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}}. Alternatively, \code{crs} can be set to \code{NULL}, which
will typically render the map quicker but may cause countries far from the
equator or large areas to appear distorted.}

\item{origin}{\emph{Draw the receptor point as a circle?}

\emph{default:} \code{TRUE}

When \code{TRUE}, the receptor point(s) are marked with black circles.}

\item{map}{\emph{Draw a base map?}

\emph{default:} \code{TRUE}

Draws the geometries of countries under the trajectory paths.}

\item{map.fill}{\emph{Colour to use to fill the polygons of the base map.}

\emph{default:} \code{"grey85"}

See \code{colors()} for colour options. Alternatively, a hexadecimal color code
can be provided.}

\item{map.colour}{\emph{Colour to use for the polygon borders of the base map.}

\emph{default:} \code{"grey75"}

See \code{colors()} for colour options. Alternatively, a hexadecimal color code
can be provided.}

\item{map.alpha}{\emph{Transparency of the base map polygons.}

\emph{default:} \code{0.8}

Must be between \code{0} (fully transparent) and \code{1} (fully opaque).}

\item{map.lwd}{\emph{Line width of the base map polygon borders.}

\emph{default:} \code{0.5}

Any numeric value.}

\item{map.lty}{\emph{Line type of the base map polygon borders.}

\emph{default:} \code{1}

See \code{\link[ggplot2:scale_linetype]{ggplot2::scale_linetype()}} for common examples. The default, \code{1},
draws solid lines.}

\item{facet}{Deprecated. Please use \code{type}.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:ggsf]{ggplot2::coord_sf}}
  \describe{
    \item{\code{expand}}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}
    \item{\code{datum}}{CRS that provides datum to use when generating graticules.}
    \item{\code{label_graticule}}{Character vector indicating which graticule lines should be labeled
where. Meridians run north-south, and the letters \code{"N"} and \code{"S"} indicate that
they should be labeled on their north or south end points, respectively.
Parallels run east-west, and the letters \code{"E"} and \code{"W"} indicate that they
should be labeled on their east or west end points, respectively. Thus,
\code{label_graticule = "SW"} would label meridians at their south end and parallels at
their west end, whereas \code{label_graticule = "EW"} would label parallels at both
ends and meridians not at all. Because meridians and parallels can in general
intersect with any side of the plot panel, for any choice of \code{label_graticule} labels
are not guaranteed to reside on only one particular side of the plot panel. Also,
\code{label_graticule} can cause labeling artifacts, in particular if a graticule line
coincides with the edge of the plot panel. In such circumstances, \code{label_axes} will
generally yield better results and should be used instead.

This parameter can be used alone or in combination with \code{label_axes}.}
    \item{\code{label_axes}}{Character vector or named list of character values
specifying which graticule lines (meridians or parallels) should be labeled on
which side of the plot. Meridians are indicated by \code{"E"} (for East) and
parallels by \code{"N"} (for North). Default is \code{"--EN"}, which specifies
(clockwise from the top) no labels on the top, none on the right, meridians
on the bottom, and parallels on the left. Alternatively, this setting could have been
specified with \code{list(bottom = "E", left = "N")}.

This parameter can be used alone or in combination with \code{label_graticule}.}
    \item{\code{lims_method}}{Method specifying how scale limits are converted into
limits on the plot region. Has no effect when \code{default_crs = NULL}.
For a very non-linear CRS (e.g., a perspective centered
around the North pole), the available methods yield widely differing results, and
you may want to try various options. Methods currently implemented include \code{"cross"}
(the default), \code{"box"}, \code{"orthogonal"}, and \code{"geometry_bbox"}. For method \code{"cross"},
limits along one direction (e.g., longitude) are applied at the midpoint of the
other direction (e.g., latitude). This method avoids excessively large limits for
rotated coordinate systems but means that sometimes limits need to be expanded a
little further if extreme data points are to be included in the final plot region.
By contrast, for method \code{"box"}, a box is generated out of the limits along both directions,
and then limits in projected coordinates are chosen such that the entire box is
visible. This method can yield plot regions that are too large. Finally, method
\code{"orthogonal"} applies limits separately along each axis, and method
\code{"geometry_bbox"} ignores all limit information except the bounding boxes of any
objects in the \code{geometry} aesthetic.}
    \item{\code{ndiscr}}{Number of segments to use for discretising graticule lines;
try increasing this number when graticules look incorrect.}
    \item{\code{default}}{Is this the default coordinate system? If \code{FALSE} (the default),
then replacing this coordinate system with another one creates a message alerting
the user that the coordinate system is being replaced. If \code{TRUE}, that warning
is suppressed.}
    \item{\code{clip}}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}
  }}
}
\value{
a \code{ggplot2} plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function plots back trajectories using \code{ggplot2}. The function
requires that data are imported using \code{\link[openair:importTraj]{openair::importTraj()}}. It is a
\code{ggplot2} implementation of \code{\link[openair:trajPlot]{openair::trajPlot()}} with many of the same
arguments, which should be more flexible for post-hoc changes.
}
\examples{
\dontrun{
# colour by height
trajMapStatic(traj_data) +
  ggplot2::scale_color_gradientn(colors = openair::openColours())

# colour by PM10, log transform scale
trajMapStatic(traj_data, colour = "pm10") +
  ggplot2::scale_color_viridis_c(trans = "log10") +
  ggplot2::labs(color = openair::quickText("PM10"))

# color by PM2.5, lat/lon projection
trajMapStatic(traj_data, colour = "pm2.5", crs = sf::st_crs(4326)) +
  ggplot2::scale_color_viridis_c(option = "turbo") +
  ggplot2::labs(color = openair::quickText("PM2.5"))
}
}
\seealso{
\code{\link[openair:trajPlot]{openair::trajPlot()}}

\code{\link[=trajMap]{trajMap()}} for the interactive \code{leaflet} equivalent of
\code{\link[=trajMapStatic]{trajMapStatic()}}

Other static trajectory maps: 
\code{\link{trajLevelMapStatic}()}
}
\concept{static trajectory maps}
