% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTrajPaths.R
\name{addTrajPaths}
\alias{addTrajPaths}
\title{Add trajectory paths to leaflet map}
\usage{
addTrajPaths(
  map,
  lng = "lon",
  lat = "lat",
  layerId = NULL,
  group = NULL,
  data,
  npoints = 12,
  ...
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet:leaflet]{leaflet::leaflet()}}.}

\item{lng}{The decimal longitude.}

\item{lat}{The decimal latitude.}

\item{layerId}{The layer id.}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet:remove]{leaflet::clearGroup()}} and \code{\link[leaflet:addLayersControl]{leaflet::addLayersControl()}} purposes).
Human-friendly group names are permitted–they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{data}{Data frame, the result of importing a trajectory file using
\code{\link[openair:importTraj]{openair::importTraj()}}.}

\item{npoints}{A dot is placed every \code{npoints} along each full trajectory.
For hourly back trajectories points are plotted every \code{npoints} hours. This
helps to understand where the air masses were at particular times and get a
feel for the speed of the air (points closer together correspond to slower
moving air masses). Defaults to \code{12}.}

\item{...}{Other arguments to pass to both \code{\link[leaflet:map-layers]{leaflet::addCircleMarkers()}} and
\code{\link[leaflet:map-layers]{leaflet::addPolylines()}}. If you use the \code{color} argument, it is important
to ensure the vector you supply is of length one to avoid issues with
\code{\link[leaflet:map-layers]{leaflet::addPolylines()}} (i.e., use \code{color = ~ pal(nox)[1]}). Note that
\code{opacity} controls the opacity of the lines and \code{fillOpacity} the opacity
of the markers.}
}
\value{
A leaflet object.
}
\description{
This function is similar (but not identical to) the \code{\link[leaflet:map-layers]{leaflet::addMarkers()}}
function in \code{leaflet}, which allows users to add trajectory paths to any
leaflet map and have more control over groups and layerIds than in
"all-in-one" functions like \code{\link[=trajMap]{trajMap()}}.
}
\details{
\code{\link[=addTrajPaths]{addTrajPaths()}} can be a powerful way of quickly plotting
trajectories on a leaflet map, but users should take some care due to any
additional arguments being passed to both \code{\link[leaflet:map-layers]{leaflet::addCircleMarkers()}} and
\code{\link[leaflet:map-layers]{leaflet::addPolylines()}}. In particular, users should be weary of the use
of the \code{color} argument. Specifically, if \code{color} is passed a vector of
length greater than one, multiple polylines will be drawn on top of one
another. At best this will affect opacity, but at worst this will
significantly impact the performance of R and the final leaflet map.

To mitigate this, please ensure that any vector passed to \code{color} is of
length one. This is simple if you want the whole path to be the same
colour, but more difficult if you want to colour by a pollutant, for
example. The easiest way to achieve this is to write a for loop or use
another iterative approach (e.g. the \code{purrr} package) to add one path per
arrival date. An example of this is provided in the Examples.
}
\examples{
\dontrun{
library(leaflet)
library(openairmaps)

pal <- colorNumeric(palette = "viridis", domain = traj_data$nox)

map <- leaflet() \%>\%
  addTiles()

for (i in seq(length(unique(traj_data$date)))) {
  data <- dplyr::filter(traj_data, date == unique(traj_data$date)[i])

  map <- map \%>\%
    addTrajPaths(
      data = data,
      color = pal(data$nox)[1]
    )
}

map
}
}
