% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{binData}
\alias{binData}
\title{Bin data, calculate mean and bootstrap 95\% confidence interval in the mean}
\usage{
binData(mydata, bin = "nox", uncer = "no2", n = 40, interval = NA,
  breaks = NA)
}
\arguments{
\item{mydata}{Name of the data frame to process.}

\item{bin}{The name of the column to divide into intervals}

\item{uncer}{The name of the column for which the mean, lower and upper
uncertainties should be calculated for each interval of \code{bin}.}

\item{n}{The number of intervals to split \code{bin} into.}

\item{interval}{The interval to be used for binning the data.}

\item{breaks}{User specified breaks to use for binning.}
}
\value{
Retruns a summarised data frame with new columns for the mean and
  upper / lower 95\% confidence intervals in the mean.
}
\description{
Bin a variable and calculate mean an uncertainties in mean
}
\details{
This function summarises data by intervals and calculates the mean and
bootstrap 95\% confidence intervals in the mean of a chosen variable in a data
frame. Any other numeric variables are summarised by their mean intervals.

There are three options for binning. The default is to bon \code{bin} into 40
intervals. Second, the user can choose an binning interval e.g.
\code{interval = 5}. Third, the user can supply their own breaks to use as
binning intervals.
}
\examples{
# how does nox vary by intervals of wind speed?
results <- binData(mydata, bin = "ws", uncer = "nox")

# easy to plot this using ggplot2
\dontrun{
library(ggplot2)
ggplot(results, aes(ws, mean, ymin = min, ymax = max)) + 
geom_pointrange()

}
}
