% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_transcription.R
\name{create_transcription}
\alias{create_transcription}
\title{Create transcription}
\usage{
create_transcription(
  file,
  model = "whisper-1",
  prompt = NULL,
  response_format = "json",
  temperature = 0,
  language = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{file}{required; a length one character vector.}

\item{model}{required; a length one character vector equals to \code{"whisper-1"}.}

\item{prompt}{optional; defaults to \code{NULL}; a length one character vector.}

\item{response_format}{required; defaults to \code{"json"}; length one character
vector equals to \code{"json"}. \strong{Currently only \code{"json"} is implemented.}}

\item{temperature}{required; defaults to \code{1}; a length one numeric vector
with the value between \code{0} and \code{2}.}

\item{language}{optional; defaults to \code{NULL}; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain a transcription and
supplementary information.
}
\description{
Transcribes audio into the input language. See
\href{https://platform.openai.com/docs/api-reference/audio/create}{this page}
for details.
}
\details{
For arguments description please refer to the \href{https://platform.openai.com/docs/api-reference/audio/create}{official documentation}.
}
\examples{
\dontrun{
voice_sample_en <- system.file(
    "extdata", "sample-en.m4a", package = "openai"
)
create_transcription(file = voice_sample_en)
}
}
\seealso{
Other audio functions: 
\code{\link{create_translation}()}
}
\concept{audio functions}
