% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_moderation.R
\name{create_moderation}
\alias{create_moderation}
\title{Create moderation}
\usage{
create_moderation(
  input,
  model = c("text-moderation-stable", "text-moderation-latest"),
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{input}{required; an arbitrary length character vector.}

\item{model}{required; a length one character vector. One among
\code{"text-moderation-stable"} and \code{"text-moderation-latest"}.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain information about the
model.
}
\description{
Classifies if text violates OpenAI's Content Policy. See \href{https://beta.openai.com/docs/api-reference/moderations/create}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/completions/create}{official documentation}.
}
\examples{
\dontrun{
create_moderation("I want to kill them all.")
}
}
