% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stackplot.r
\name{stackplotVA}
\alias{stackplotVA}
\title{plot grouped CSMF from a "insilico" object}
\usage{
stackplotVA(x, grouping = NULL, type = c("stack", "dodge")[1],
  order.group = NULL, order.sub = NULL, err = TRUE, CI = 0.95,
  sample.size.print = FALSE, xlab = "Group", ylab = "CSMF", ylim = NULL,
  title = "CSMF by broader cause categories", horiz = FALSE, angle = 60,
  err_width = 0.4, err_size = 0.6, point_size = 2, border = "black",
  bw = FALSE, ...)
}
\arguments{
\item{x}{one or a list of fitted object from \code{codeVA} function}

\item{grouping}{C by 2 matrix of grouping rule. If set to NULL, make it default.}

\item{type}{type of the plot to make}

\item{order.group}{list of grouped categories. If set to NULL, make it default.}

\item{order.sub}{Specification of the order of sub-populations to plot}

\item{err}{indicator of inclusion of error bars}

\item{CI}{confidence interval for error bars.}

\item{sample.size.print}{Logical indicator for printing also the sample size for each sub-population labels.}

\item{xlab}{Labels for the causes.}

\item{ylab}{Labels for the CSMF values.}

\item{ylim}{Range of y-axis.}

\item{title}{Title of the plot.}

\item{horiz}{Logical indicator indicating if the bars are plotted
horizontally.}

\item{angle}{Angle of rotation for the texts on x axis when \code{horiz} is
set to FALSE}

\item{err_width}{Size of the error bars.}

\item{err_size}{Thickness of the error bar lines.}

\item{point_size}{Size of the points.}

\item{border}{The color for the border of the bars.}

\item{bw}{Logical indicator for setting the theme of the plots to be black
and white.}

\item{\dots}{Not used.}
}
\description{
Produce bar plot of the CSMFs for a fitted \code{"insilico"} object in broader groups.
}
\examples{
\donttest{
data(RandomVA3)
test <- RandomVA3[1:200, ]
train <- RandomVA3[201:400, ]
fit1 <- codeVA(data = test, data.type = "customize", model = "InSilicoVA",
                    data.train = train, causes.train = "cause",
                    Nsim=1000, auto.length = FALSE)

fit2 <- codeVA(data = test, data.type = "customize", model = "InterVA",
               data.train = train, causes.train = "cause",
               version = "4.02", HIV = "h", Malaria = "l")

fit3 <- codeVA(data = test, data.type = "customize", model = "Tariff",
               data.train = train, causes.train = "cause",
               nboot.sig = 100)

data(SampleCategory3)
stackplotVA(fit1, grouping = SampleCategory3, type ="dodge",
            ylim = c(0, 1), title = "InSilicoVA")
stackplotVA(fit2, grouping = SampleCategory3, type = "dodge",
            ylim = c(0, 1), title = "InterVA4.02")
stackplotVA(fit3, grouping = SampleCategory3, type = "dodge",
            ylim = c(0, 1), title = "Tariff")
}
}
\author{
Zehang Li, Tyler McCormick, Sam Clark

Maintainer: Zehang Li <lizehang@uw.edu>
}

