% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_attributes_edges.R
\name{calc_catchment_attributes_vect_rec}
\alias{calc_catchment_attributes_vect_rec}
\title{calc_catchment_attributes_vect_rec
Aggregate attributes for the total catchment of each stream segment.}
\usage{
calc_catchment_attributes_vect_rec(dt, id, stat_vect, attr_name_vect)
}
\arguments{
\item{dt}{data.table of stream topology and attributes per segment.}

\item{id}{integer; 'stream' of outlet segment to start the calculation from.}

\item{stat_vect}{name or character vector giving the statistics to be calculated,
must be one of: min, max, mean, percent.}

\item{attr_name_vect}{name or character vector of column names for the attribute(s)
to be calculated.}
}
\value{
One row data.table with the cumulative number of cells of the total
 catchment of each segment and the values for each attribute and changes the
 values in dt.
}
\description{
Recursive function to calculate the catchment attributes of each stream
segment. It is called by \code{\link{calc_catchment_attributes_vect}} for each
outlet and should not be called by the user.
}
\keyword{internal}
