% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_attributes_edges.R
\name{calc_attributes_edges}
\alias{calc_attributes_edges}
\title{Calculate attributes of the edges.}
\usage{
calc_attributes_edges(input_raster, stat, attr_name, round_dig = 2,
  clean = TRUE)
}
\arguments{
\item{input_raster}{name or character vector of names of the raster map(s)
to calculate attributes from.}

\item{stat}{name or character vector giving the statistics to be calculated,
must be one of: min, max, mean, percent.}

\item{attr_name}{name or character vector of column names for the attribute(s)
to be calculated. Attribute names must not be longer than 8 characters.}

\item{round_dig}{integer; number of digits to round results to. Can be a vector
of different values or just one value for all attributes.}

\item{clean}{logical; should intermediate files be deleted}
}
\value{
Nothing. The function appends new columns to the 'edges' attribute
  table with column names given in \code{attr_name}. For each attribute, two
  columns are appended: one giving the attribute for the rca of the edge
  ("attribute_name_e") and one for the attribute of the total catchment of
  the edge ("attribute_name_c").
}
\description{
For each edge (i.e. stream segment) additional attributes (predictor variables)
are derived based on given raster maps.
}
\details{
First, the subcatchments for all edges are calculated. Then these are
intersected with the given raster maps and the desired statistics are computed.
This is needed to compute approximate attribute values for sites \code{\link{calc_attributes_sites_approx}}.

For \code{stat} = "percent" the \code{input_raster} must be coded as 1 and 0
 (e.g., cells occupied by the land use under consideration and not). If
  the \code{input_raster} consists of percentages per cell (e.g., proportional land
  use of a certain type per cell) \code{stat} = "mean" gives the overall proportion
  of this land use.
}
\note{
\code{\link{setup_grass_environment}}, \code{\link{import_data}},
\code{\link{derive_streams}} and \code{\link{calc_edges}} must be run before.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.2.0"
  } else {
  gisbase = "/usr/lib/grass72/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
setup_grass_environment(dem = dem_path, sites = sites_path)
import_data(dem = dem_path, sites = sites_path)
gmeta()

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 700, condition = TRUE, clean = TRUE)

# Check and correct complex junctions (there are no complex juctions in this 
# example date set)
cj <- check_compl_junctions()
if(cj){
  correct_compl_junctions()
}

# Prepare edges
calc_edges()

# Plot data
dem <- readRAST('dem', ignore.stderr = TRUE)
edges <- readVECT('edges', ignore.stderr = TRUE)
plot(dem, col = terrain.colors(20))
lines(edges, col = "blue", lwd = 2)
}

}
\author{
Mira Kattwinkel, \email{mira.kattwinkel@gmx.net}
}
