/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;

public class DefiniteNounResolver
extends MaxentResolver {
    public DefiniteNounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "defmodel", m, 80);
    }

    public DefiniteNounResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "defmodel", m, 80, nrr);
    }

    public boolean canResolve(MentionContext mention) {
        Object[] mtokens = mention.getTokens();
        String firstTok = mention.getFirstTokenText().toLowerCase();
        boolean rv = mtokens.length > 1 && !mention.getHeadTokenTag().startsWith("NNP") && this.definiteArticle(firstTok, mention.getFirstTokenTag());
        return rv;
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList features = new ArrayList();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(DefiniteNounResolver.getContextFeatures(mention));
            features.addAll(this.getStringMatchFeatures(mention, entity));
            features.addAll(this.getDistanceFeatures(mention, entity));
        }
        return features;
    }
}

