/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;

public class ProperNounResolver
extends MaxentResolver {
    private static final Pattern initialCaps = Pattern.compile("^[A-Z]");
    private static Map acroMap;
    private static boolean acroMapLoaded;

    public ProperNounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "pnmodel", m, 500);
        if (!acroMapLoaded) {
            this.initAcronyms(projectName + "/acronyms");
            acroMapLoaded = true;
        }
        this.showExclusions = false;
    }

    public ProperNounResolver(String projectName, ResolverMode m, NonReferentialResolver nonRefResolver) throws IOException {
        super(projectName, "pnmodel", m, 500, nonRefResolver);
        if (!acroMapLoaded) {
            this.initAcronyms(projectName + "/acronyms");
            acroMapLoaded = true;
        }
        this.showExclusions = false;
    }

    public boolean canResolve(MentionContext mention) {
        return mention.getHeadTokenTag().startsWith("NNP") || mention.getHeadTokenTag().startsWith("CD");
    }

    private void initAcronyms(String name) {
        acroMap = new HashMap(15000);
        try {
            String line;
            BufferedReader str = MaxentResolver.loadAsResource() ? new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(name))) : new BufferedReader(new FileReader(name));
            while (null != (line = str.readLine())) {
                StringTokenizer st = new StringTokenizer(line, "\t");
                String acro = st.nextToken();
                String full = st.nextToken();
                Set<String> exSet = (HashSet<String>)acroMap.get(acro);
                if (exSet == null) {
                    exSet = new HashSet<String>();
                    acroMap.put(acro, exSet);
                }
                exSet.add(full);
                exSet = (Set)acroMap.get(full);
                if (exSet == null) {
                    exSet = new HashSet();
                    acroMap.put(full, exSet);
                }
                exSet.add(acro);
            }
        }
        catch (IOException e) {
            System.err.println("ProperNounResolver.initAcronyms: Acronym Database not found: " + e);
        }
    }

    private MentionContext getProperNounExtent(DiscourseEntity de) {
        Iterator ei = de.getMentions();
        while (ei.hasNext()) {
            MentionContext xec = (MentionContext)ei.next();
            String xecHeadTag = xec.getHeadTokenTag();
            if (!xecHeadTag.startsWith("NNP") && !initialCaps.matcher(xec.getHeadTokenText()).find()) continue;
            return xec;
        }
        return null;
    }

    private boolean isAcronym(String ecStrip, String xecStrip) {
        Set exSet = (Set)acroMap.get(ecStrip);
        return exSet != null && exSet.contains(xecStrip);
    }

    protected List getAcronymFeatures(MentionContext mention, DiscourseEntity entity) {
        MentionContext xec = this.getProperNounExtent(entity);
        String ecStrip = this.stripNp(mention);
        String xecStrip = this.stripNp(xec);
        if (ecStrip != null && xecStrip != null && this.isAcronym(ecStrip, xecStrip)) {
            ArrayList<String> features = new ArrayList<String>(1);
            features.add("knownAcronym");
            return features;
        }
        return Collections.EMPTY_LIST;
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList features = new ArrayList();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(this.getStringMatchFeatures(mention, entity));
            features.addAll(this.getAcronymFeatures(mention, entity));
        }
        return features;
    }

    public boolean excluded(MentionContext mention, DiscourseEntity entity) {
        if (super.excluded(mention, entity)) {
            return true;
        }
        Iterator ei = entity.getMentions();
        while (ei.hasNext()) {
            MentionContext xec = (MentionContext)ei.next();
            if (!xec.getHeadTokenTag().startsWith("NNP")) continue;
            return false;
        }
        return true;
    }

    static {
        acroMapLoaded = false;
    }
}

