% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.datasource.R
\name{opal.valueset}
\alias{opal.valueset}
\title{Get the values of an entity}
\usage{
opal.valueset(opal, datasource, table, identifier)
}
\arguments{
\item{opal}{Opal object.}

\item{datasource}{Name of the datasource.}

\item{table}{Name of the table in the datasource.}

\item{identifier}{Entity identifier.}
}
\description{
Get the values of an entity in a table.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.valueset(o, 'CNSIM', 'CNSIM1', '1008573362')
opal.logout(o)
}
}
\seealso{
Other datasource functions: 
\code{\link{opal.annotate}()},
\code{\link{opal.annotations}()},
\code{\link{opal.attribute_values}()},
\code{\link{opal.datasources}()},
\code{\link{opal.datasource}()},
\code{\link{opal.tables}()},
\code{\link{opal.table}()},
\code{\link{opal.variable_summary}()},
\code{\link{opal.variables}()},
\code{\link{opal.variable}()}
}
\concept{datasource functions}
