% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.admin.r
\name{oadmin.install_local_package}
\alias{oadmin.install_local_package}
\title{Install a package from a local archive file}
\usage{
oadmin.install_local_package(opal, path)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{path}{Path to the package archive file.}
}
\description{
Install a package from a package archive file. This will upload the archive file and run its installation in the R server.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# install a pre-built local archive file
oadmin.install_local_package(o, '~/Rserve_1.8-7.tar.gz')
# or build archive file from local package source (in current working folder)
oadmin.install_local_package(o, devtools::build())
opal.logout(o)
}
}
\seealso{
Other administration functions: 
\code{\link{oadmin.install_bioconductor_package}()},
\code{\link{oadmin.install_devtools}()},
\code{\link{oadmin.install_github_package}()},
\code{\link{oadmin.install_package}()},
\code{\link{oadmin.installed_devtools}()},
\code{\link{oadmin.installed_packages}()},
\code{\link{oadmin.installed_package}()},
\code{\link{oadmin.package_description}()},
\code{\link{oadmin.remove_package}()}
}
\concept{administration functions}
