% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.assign.r
\name{opal.assign.resource}
\alias{opal.assign.resource}
\title{Resource assignment}
\usage{
opal.assign.resource(opal, symbol, value, async = FALSE)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{symbol}{Name of the R symbol.}

\item{value}{The fully qualified name of a resource in Opal.}

\item{async}{R script is executed asynchronously within the session (default is FALSE). If TRUE, the value returned is the ID of the command to look for (from Opal 2.1).}
}
\description{
Assign a ResourceClient object to a R symbol in the current R session.
}
\examples{
\dontrun{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
# assign a resource and make some operation on it
opal.assign.resource(o, "D", "datashield.cram1")
opal.execute(o, "class(D)")
opal.logout(o)
}
}
\seealso{
Other assignment functions: 
\code{\link{opal.assign.data}()},
\code{\link{opal.assign.script}()},
\code{\link{opal.assign.table.tibble}()},
\code{\link{opal.assign.table}()},
\code{\link{opal.assign}()}
}
\concept{assignment functions}
