% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{posterior_lambda_KDE_Distr}
\alias{posterior_lambda_KDE_Distr}
\title{Get distributions of analytical posterior}
\usage{
posterior_lambda_KDE_Distr(tree.list, n.sim = 10, BR.name)
}
\arguments{
\item{tree.list}{multiSimmap object.}

\item{n.sim}{integer. Number of simulations.}

\item{BR.name}{character. A label name for the anatomical region.}
}
\value{
A tibble with the simulated distribution.
}
\description{
Simulates a distribution of number of state changes across all branches of all trees
}
\examples{
data("hym_stm_amalg")
# Get a sample of ten stochastic maps from head.
tree_list <- hym_stm_amalg$head[1:10]
tree_list <- merge_tree_cat_list(tree_list)
# Simulate posterior poisson distribution.
posterior_lambda_KDE_Distr(tree_list, n.sim = 10, BR.name = "head")

}
\author{
Sergei Tarasov
}
