% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stairs.R
\name{stairs}
\alias{stairs}
\title{Plotting stairs with time point at end of interval.}
\usage{
stairs(x, y, type = "b", preline = FALSE, pch = 19, ...)
}
\arguments{
\item{x}{x values for plot.}

\item{y}{y values for plot.}

\item{type}{if 'b' then include points.}

\item{preline}{if TRUE, then a line backwards from the first point is added.}

\item{pch}{Passed to \code{points()}.}

\item{...}{Passed to \code{lines()} and \code{points()} when they are called in the function.}
}
\description{
Plotting steps with time point at end of interval
}
\details{
It's easy to plot stairs with \code{plot(x,y,type="s")}, however that makes the steps forward from \code{x}, for time series this works if the time points are at the beginning of the intervals.

Often with time series the time points are in the end of the intervals, so the steps should go backaward, this is achieved with this function.
}
\examples{

# Usual stairs plot has steps forward from x
x <- rnorm(10)
plot(1:10, x, type="s")

# Stairs with step backward from x
plot(1:10, x, type="n")
stairs(1:10, x)

# Use for time series plotting
plot_ts(Dbuilding, "heatload", c("2010-12-15","2010-12-16"), plotfun=stairs)

# Set it globally for all plot_ts
p <- par_ts()
p$plotfun <- stairs
options(par_ts=p)
plot_ts(Dbuilding, "heatload", c("2010-12-15","2010-12-16"))

# Modify it to only lines
plot_ts(Dbuilding, "heatload", c("2010-12-15","2010-12-16"),
        plotfun=function(x,y,...){stairs(x,y, type="l")})

}
