% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rls_predict.R
\name{rls_predict}
\alias{rls_predict}
\title{Prediction with an rls model.}
\usage{
rls_predict(model, datatr = NA)
}
\arguments{
\item{model}{Onlineforecast model object which has been fitted.}

\item{datatr}{Transformed data.}
}
\value{
The Yhat forecast matrix with a forecast for each model$kseq and for each time point in \code{datatr$t}.
}
\description{
Use a fitted forecast model to predict its output variable with transformed data.
}
\details{
See the ??ref(recursive updating vignette, not yet available).
}
\examples{

# Take data
D <- subset(Dbuilding, c("2010-12-15", "2011-01-01"))
D$y <- D$heatload
# Define a simple model 
model <- forecastmodel$new()
model$add_inputs(Ta = "Ta", mu = "one()")
model$add_regprm("rls_prm(lambda=0.99)")

# Before fitting the model, define which points to include in the evaluation of the score function
D$scoreperiod <- in_range("2010-12-20", D$t)
# And the sequence of horizons to fit for
model$kseq <- 1:6

# Transform using the mdoel
datatr <- model$transform_data(D)

# See the transformed data
str(datatr)

# The model has not been fitted
model$Lfits

# To fit
rls_fit(model=model, data=D)

# Now the fits for each horizon are there (the latest update)
# For example the current parameter estimates
model$Lfits$k1$theta

# Use the current values for prediction
D$Yhat <- rls_predict(model, datatr)

# Plot it
plot_ts(D, c("y|Yhat"), kseq=1)

# Recursive updating and prediction
Dnew <- subset(Dbuilding, c("2011-01-01", "2011-01-02"))

for(i in 1:length(Dnew$t)){
    # New data arrives
    Dt <- subset(Dnew, i)
    # Remember that the transformation must only be done once if some transformation
    # which is has a state, e.g. lp(), is used
    datatr <- model$transform_data(Dt)
    # Update, remember that this must only be once for each new point
    # (it updates the parameter estimates, i.e. model$Lfits)
    rls_update(model, datatr, Dt$heatload)
    # Now predict to generate the new forecast
    print(rls_predict(model, datatr))
}

}
