% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator_multiply.R
\name{\%**\%}
\alias{\%**\%}
\title{Multiplication of list with y, elementwise}
\usage{
x \%**\% y
}
\arguments{
\item{x}{a list of matrices, data.frames, etc.}

\item{y}{a vector, data.frame or matrix}
}
\value{
A list of same length of x
}
\description{
Multiplication of each element in a list (x) with y
}
\details{
Each element of x is multiplied with y using the usual elementwise '*' operator.

Typical use is when a function, e.g. \code{\link{bspline}()}, returns a list of matrices (e.g. one for each base spline) and they should individually be multiplied with y (a vector, matrix, etc.).

Since this is intended to be used for forecast models in the transformation stage 
then there are some percularities:

If the number of columns or the names of the columns are not equal for one element in x
and y, then only the columns with same names are used, hence the resulting matrices can be
of lower dimensions.

See the example \url{https://onlineforecasting.org/examples/solar-power-forecasting.html} where the operator is used.
}
\examples{

x <- list(matrix(1:9,3), matrix(9:1,3))
x

y <- matrix(2,3,3)
y

x \%**\% y

y <- 1:3

x \%**\% y

# Naming percularity
nams(x[[1]]) <- c("k1","k2","k3")
nams(x[[2]]) <- c("k2","k3","k4")
y <- matrix(2,3,3)
nams(y) <- c("k1","k3","k7")

# Now the only the horizons matching will be used
x \%**\% y

}
