% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_route.R
\name{get_route}
\alias{get_route}
\title{Get Route Information}
\usage{
get_route(
  token,
  start,
  end,
  route,
  date = Sys.Date(),
  time = format(Sys.time(), format = "\%T"),
  mode = NULL,
  max_dist = NULL,
  n_itineraries = 3,
  status_info = FALSE
)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{start}{Vector of c(lat, lon) coordinates for the route start point}

\item{end}{Vector of c(lat, lon) coordinates for the route end point}

\item{route}{Type of route. Accepted values are \code{walk}, \code{drive}, \code{pt} (public transport), or \code{cycle}}

\item{date}{Default = current date. Date for which route is requested.}

\item{time}{Default = current time. Time for which route is requested.}

\item{mode}{Required if \code{route = "pt"}. Accepted values are \code{transit}, \code{bus} or \code{rail}}

\item{max_dist}{Optional if \code{route = "pt"}. Maximum walking distance}

\item{n_itineraries}{Optional if \code{route = "pt"}. Default = 3. The number of potential routes to provide.}

\item{status_info}{Default = \code{FALSE}. Whether to return output as a list including a list of status information and a tibble of output}
}
\value{
If no error occurs and \code{status_info = TRUE}:
\describe{
  \item{status_info}{A list containing information about the query status. If \code{route = "pt"}, the output contains lists \code{request_params}, \code{debug_output} and \code{elevation}. Else, the list contains the variables \code{status} and \code{status_msg}}
  \item{result}{A tibble containing the data retrieved from the query. This is the only output if status_info = \code{FALSE}. Each row is an itinerary. Output dimensions vary between \code{route = "pt"} and other routes}
}

If an error occurs, the output will be \code{NULL}, along with a warning message.
}
\description{
This function is a wrapper for the \href{https://docs.onemap.sg/#route}{Route Service API}. It returns the full route data in a tibble format, or a list of 2 tibbles with results and status information if desired.
}
\examples{
# returns output tibble
\dontrun{get_route(token, c(1.319728, 103.8421), c(1.319728905, 103.8421581), "drive")}
\dontrun{get_route(token, c(1.319728, 103.8421), c(1.319728905, 103.8421581), "pt",
    mode = "bus", max_dist = 300, n_itineraries = 2)}

# returns list of status list and output tibble
\dontrun{get_route(token, c(1.319728, 103.8421), c(1.319728905, 103.8421581),
    "drive", status_info = TRUE)}

# error: output is NULL, warning message shows status code
\dontrun{get_route("invalid_token", c(1.319728, 103.8421), c(1.319728905, 103.8421581), "drive")}

# error: output is NULL, warning message shows error message from request
\dontrun{get_route(token, c(300, 300), c(400, 500), "cycle")}
\dontrun{get_route(token, c(1.319728, 103.8421), c(1.319728905, 103.8421581), "fly")}
}
