% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margins.R
\name{margins}
\alias{margins}
\title{Compute Marginal Effects for One-inflated models}
\usage{
margins(model, df, at = "AE", verbose = TRUE)
}
\arguments{
\item{model}{An object representing a fitted model. Must be of class \code{oneinflmodel} or \code{truncmodel}.}

\item{df}{A \code{data.frame} containing the dataset used to fit the model. The variables in the data must match those used in the model.}

\item{at}{A character string or list specifying where to evaluate the marginal effects:
\itemize{
\item \code{"AE"}: Average Effect (marginal effect averaged over all data points; default).
\item \code{"EM"}: Effect at Means (marginal effect evaluated at the sample means of the data).
\item A named list: A custom case specifying representative values for variables.
}}

\item{verbose}{Logical; if \code{TRUE} (default), prints the summary output. If \code{FALSE}, suppresses output table and returns a list containing several components.}
}
\value{
If \code{verbose=TRUE} (default), prints the marginal effects, their standard errors, z-values, p-values, and significance levels.

If \code{verbose=FALSE}, returns a list containing the following components:
\describe{
\item{\code{where}}{A description of how the marginal effects have been evaluated.}
\item{\code{dEdq}}{The marginal effect. The partial derivative of the expected count with respect to a variable \code{q} in the \code{X} and or \code{Z} matrix, or the difference in expectation if \code{q} is binary.}
\item{\code{se}}{The standard errors of the marginal effects evaluated numerically and using a Jacobian via the delta method.}
}
}
\description{
This wrapper function calls a different function to calculate marginal effects depending on the model type.
The marginal effects of the variables are evaluated at specified points, such as the sample means or averages, or at custom-defined cases.
}
\details{
The function computes marginal effects for zero-truncated Poisson or negative binomial regression models.
It handles different model types; \code{oneinflmodel} for one-inflated models, and \code{truncmodel} for standard count models.
The marginal effects are evaluated at either all data points and averaged (\code{AE}, the default), at the sample means of the variables (\code{EM}), or at a custom case.
The marginal effects for dummy variables are actually the differences in expected outcomes for values of the dummy of 1 and 0.
The marginal effects are displayed along with their statistical significance, evaluated based on the chosen \code{at} parameter.
}
\examples{
df <- data.frame(x = rnorm(100), z = rnorm(100), y = rpois(100, lambda = 5))
model <- oneinfl(y ~ x | z, df = df, dist = "Poisson")
margins(model, df, at = "AE") # Average Effect
margins(model, df, at = "EM", verbose=FALSE) # Effect at Means, suppress printing
margins(model, df, at = list(x = 1, z = 0)) # Custom case

}
\seealso{
\code{\link{dEdq_nb}}, \code{\link{dEdq_nb_noinfl}}, \code{\link{dEdq_pois}},
\code{\link{dEdq_pois_noinfl}}, \code{\link{model.frame}},
\code{\link{model.matrix}}, \code{\link[stats]{numericDeriv}}
}
