% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_subset_extract.R
\name{subset-odm}
\alias{subset-odm}
\alias{[,ondisc_matrix,missing,missing,missing-method}
\alias{[,ondisc_matrix,ANY,missing,missing-method}
\alias{[,ondisc_matrix,missing,ANY,missing-method}
\alias{[,ondisc_matrix,ANY,ANY,missing-method}
\alias{[,metadata_ondisc_matrix,ANY,ANY,missing-method}
\alias{[,metadata_ondisc_matrix,ANY,missing,missing-method}
\alias{[,metadata_ondisc_matrix,missing,ANY,missing-method}
\alias{[,metadata_ondisc_matrix,missing,missing,missing-method}
\alias{[,multimodal_ondisc_matrix,missing,missing,missing-method}
\alias{[,multimodal_ondisc_matrix,missing,ANY,missing-method}
\alias{[,multimodal_ondisc_matrix,ANY,ANY,ANY-method}
\title{Subset using the \code{[} operator.}
\usage{
\S4method{[}{ondisc_matrix,missing,missing,missing}(x, i, j, drop)

\S4method{[}{ondisc_matrix,ANY,missing,missing}(x, i, j)

\S4method{[}{ondisc_matrix,missing,ANY,missing}(x, i, j)

\S4method{[}{ondisc_matrix,ANY,ANY,missing}(x, i, j)

\S4method{[}{metadata_ondisc_matrix,ANY,ANY,missing}(x, i, j, drop)

\S4method{[}{metadata_ondisc_matrix,ANY,missing,missing}(x, i, j, drop)

\S4method{[}{metadata_ondisc_matrix,missing,ANY,missing}(x, i, j, drop)

\S4method{[}{metadata_ondisc_matrix,missing,missing,missing}(x, i, j, drop)

\S4method{[}{multimodal_ondisc_matrix,missing,missing,missing}(x, i, j, drop)

\S4method{[}{multimodal_ondisc_matrix,missing,ANY,missing}(x, i, j, drop)

\S4method{[}{multimodal_ondisc_matrix,ANY,ANY,ANY}(x, i, j, drop)
}
\arguments{
\item{x}{an \code{ondisc_matrix}, \code{metadata_ondisc_matrix}, or \code{multimodal_ondisc_matrix} object.}

\item{i}{a vector (numeric, logical, or character) indicating features to keep.}

\item{j}{a vector (numeric, logical, or character) indicating cells to keep.}

\item{drop}{not used}
}
\value{
An appropriately subset object of the same class as \code{x}.
}
\description{
Apply the \code{[} operator to an \code{ondisc_matrix}, \code{metadata_ondisc_matrix}, or \code{multimodal_ondisc_matrix}
to subset the object. You can pass logical, character, or numeric vectors to \code{[}; character
vectors are assumed to refer to feature IDs (for rows) and cell barcodes (for columns).
}
\details{
You can subset an \code{ondisc_matrix} and a \code{metadata_ondisc_matrix} by cell and/or feature. You can subset a
\code{multimodal_ondisc_matrix} by cell only (because the features differ across modalities).
}
\examples{
# NOTE: You must create the RDS files "expressions.rds" and
# "perturbations.rds" to run this example. Navigate to the help file of
# "create_ondisc_matrix_from_mtx" (via ?create_ondisc_matrix_from_mtx),
# and execute both code blocks.

# subset an ondisc_matrix
h5_fp <- paste0(tempdir(), "/expressions.h5")
if (file.exists(h5_fp)) {
odm <- ondisc_matrix(h5_file = h5_fp)
# keep cells 100-110
x <- odm[,100:110]
# keep all cells except 50, 100, 150
x <- odm[,-c(50, 100, 150)]
# keep genes ENSG00000188305, ENSG00000257284, and ENSG00000251655:
x <- odm[c("ENSG00000188305", "ENSG00000257284", "ENSG00000251655"),]
# keep the cells CTTAGGACACTGGCGT-1 and AAAGGATTCACATCAG-1:
x <- odm[,c("CTTAGGACACTGGCGT-1", "AAAGGATTCACATCAG-1")]
# keep all genes except ENSG00000188305 and ENSG00000257284
x <- odm[!(get_feature_ids(odm) \%in\% c("ENSG00000188305", "ENSG00000257284")),]
}

# subset a metadata_ondic_matrix
expressions_fp <- paste0(tempdir(), "/expressions.rds")
if (file.exists(expressions_fp)) {
expressions <- readRDS(expressions_fp)
# keep cells 100-110
x <- expressions[,100:110]
# keep genes ENSG00000188305, ENSG00000257284, and ENSG00000251655
x <- expressions[c("ENSG00000188305", "ENSG00000257284", "ENSG00000251655"),]
}

# subset a multimodal ondisc_matrix
expression_fp <- paste0(tempdir(), "/expressions.rds")
perturbations_fp <- paste0(tempdir(), "/perturbations.rds")
if (file.exists(expression_fp) && file.exists(perturbations_fp)) {
    expressions <- readRDS(expression_fp)
    perturbations <- readRDS(expression_fp)
    crispr_experiment <- multimodal_ondisc_matrix(list(expressions = expressions,
    perturbations = perturbations))
    # Keep all cells except 10,100, and 105.
    x <- crispr_experiment[,-c(10,100,105)]
    # Keep the first 5 cells
    x <- crispr_experiment[,1:5]
}
}
