% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeLists.r
\name{mergeLists}
\alias{mergeLists}
\title{Merge two lists with precedence}
\usage{
mergeLists(list1, list2)
}
\arguments{
\item{list1, list2}{Lists.}
}
\value{
A list.
}
\description{
This function merges two lists to create a single, combined list. If there is a conflict (e.g., two elements have the same name), items in the second list gain preference. Adapted from Stack Overflow (http://stackoverflow.com/questions/13811501/r-merge-lists-with-overwrite-and-recursion).
}
\examples{
list1 <- list(a=1:3, b='Hello world', c=LETTERS[1:3])
list2 <- list(x=4, b='Goodbye world', z=letters[1:2])
mergeLists(list1, list2)
mergeLists(list2, list1)
list3 <- list(m=list(n=4:7, o=pi), a=1:5)
mergeLists(list1, list3)
}
