# output from rsquared forward regression is as expected

    Code
      ols_step_forward_r2(model)
    Output
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6            33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1            32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3            31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2            29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4            29302.797    29358.121    -27454.740    0.74962    0.74956 
       6      x5            29304.734    29367.962    -27452.802    0.74962    0.74955 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.168 
      Pred R-Squared          0.749       AIC                29304.734 
      MAE                     0.402       SBC                29367.962 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                        ANOVA                                    
      --------------------------------------------------------------------------
                       Sum of                                                   
                      Squares           DF    Mean Square       F          Sig. 
      --------------------------------------------------------------------------
      Regression    15163.548            6       2527.258    9976.429    0.0000 
      Residual       5064.685        19993          0.253                       
      Total         20228.233        19999                                      
      --------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.591    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.997    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.766    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.062    -0.014    0.000 
               x5    -0.001         0.004       -0.001    -0.250    0.802    -0.008    0.006 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_r2(model, progress = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Variables Entered: 
      
      => x6 
      => x1 
      => x3 
      => x2 
      => x4 
      => x5 
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6            33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1            32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3            31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2            29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4            29302.797    29358.121    -27454.740    0.74962    0.74956 
       6      x5            29304.734    29367.962    -27452.802    0.74962    0.74955 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.168 
      Pred R-Squared          0.749       AIC                29304.734 
      MAE                     0.402       SBC                29367.962 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                        ANOVA                                    
      --------------------------------------------------------------------------
                       Sum of                                                   
                      Squares           DF    Mean Square       F          Sig. 
      --------------------------------------------------------------------------
      Regression    15163.548            6       2527.258    9976.429    0.0000 
      Residual       5064.685        19993          0.253                       
      Total         20228.233        19999                                      
      --------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.591    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.997    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.766    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.062    -0.014    0.000 
               x5    -0.001         0.004       -0.001    -0.250    0.802    -0.008    0.006 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_r2(model, details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Step     => 0 
      Model    => y ~ 1 
      R2       => 0 
      
      Initiating stepwise selection... 
      
                               Table: Adding New Variables                           
      ------------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2  
      ------------------------------------------------------------------------------
      x6            1    33473.297    33497.007    -23285.069    0.69145     0.69143 
      x1            1    43073.160    43096.870    -13686.868    0.50136     0.50133 
      x3            1    43267.194    43290.904    -13492.863    0.49650     0.49647 
      x2            1    43561.884    43585.595    -13198.216    0.48902     0.48900 
      x4            1    56989.595    57013.305       227.932      4e-05      -1e-05 
      x5            1    56990.439    57014.149       228.776    0.00000      -5e-05 
      ------------------------------------------------------------------------------
      
      Step     => 1 
      Added    => x6 
      Model    => y ~ x6 
      R2       => 0.69145 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x1            1    32931.758    32963.372    -23826.833    0.69972    0.69969 
      x3            1    32959.771    32991.385    -23798.829    0.69930    0.69927 
      x2            1    33033.295    33064.909    -23725.325    0.69819    0.69816 
      x4            1    33470.717    33502.331    -23288.023    0.69152    0.69149 
      x5            1    33475.275    33506.889    -23283.467    0.69145    0.69142 
      -----------------------------------------------------------------------------
      
      Step     => 2 
      Added    => x1 
      Model    => y ~ x6 + x1 
      R2       => 0.69972 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x3            1    31912.722    31952.239    -24845.827    0.71466    0.71462 
      x2            1    32025.492    32065.010    -24733.099    0.71305    0.71301 
      x4            1    32928.035    32967.552    -23830.887    0.69980    0.69976 
      x5            1    32933.735    32973.252    -23825.189    0.69972    0.69967 
      -----------------------------------------------------------------------------
      
      Step     => 3 
      Added    => x3 
      Model    => y ~ x6 + x1 + x3 
      R2       => 0.71466 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x2            1    29304.296    29351.717    -27453.243    0.74958    0.74953 
      x4            1    31908.533    31955.954    -24850.258    0.71475    0.71470 
      x5            1    31914.523    31961.944    -24844.270    0.71467    0.71461 
      -----------------------------------------------------------------------------
      
      Step     => 4 
      Added    => x2 
      Model    => y ~ x6 + x1 + x3 + x2 
      R2       => 0.74958 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x4            1    29302.797    29358.121    -27454.740    0.74962    0.74956 
      x5            1    29306.232    29361.556    -27451.307    0.74958    0.74952 
      -----------------------------------------------------------------------------
      
      Step     => 5 
      Added    => x4 
      Model    => y ~ x6 + x1 + x3 + x2 + x4 
      R2       => 0.74962 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x5            1    29304.734    29367.962    -27452.802    0.74962    0.74955 
      -----------------------------------------------------------------------------
      
      
      Variables Selected: 
      
      => x6 
      => x1 
      => x3 
      => x2 
      => x4 
      => x5 
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6            33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1            32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3            31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2            29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4            29302.797    29358.121    -27454.740    0.74962    0.74956 
       6      x5            29304.734    29367.962    -27452.802    0.74962    0.74955 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.168 
      Pred R-Squared          0.749       AIC                29304.734 
      MAE                     0.402       SBC                29367.962 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                        ANOVA                                    
      --------------------------------------------------------------------------
                       Sum of                                                   
                      Squares           DF    Mean Square       F          Sig. 
      --------------------------------------------------------------------------
      Regression    15163.548            6       2527.258    9976.429    0.0000 
      Residual       5064.685        19993          0.253                       
      Total         20228.233        19999                                      
      --------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.591    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.997    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.766    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.062    -0.014    0.000 
               x5    -0.001         0.004       -0.001    -0.250    0.802    -0.008    0.006 
      ---------------------------------------------------------------------------------------
      

# output from adjusted rsquared forward regression is as expected

    Code
      ols_step_forward_adj_r2(model)
    Output
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6            33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1            32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3            31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2            29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4            29302.797    29358.121    -27454.740    0.74962    0.74956 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.017 
      Pred R-Squared          0.749       AIC                29302.797 
      MAE                     0.402       SBC                29358.121 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.532            5       3032.706    11972.264    0.0000 
      Residual       5064.701        19994          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.497    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.592    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.998    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.769    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_adj_r2(model, progress = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Variables Entered: 
      
      => x6 
      => x1 
      => x3 
      => x2 
      => x4 
      
      No more variables to be added.
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6            33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1            32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3            31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2            29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4            29302.797    29358.121    -27454.740    0.74962    0.74956 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.017 
      Pred R-Squared          0.749       AIC                29302.797 
      MAE                     0.402       SBC                29358.121 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.532            5       3032.706    11972.264    0.0000 
      Residual       5064.701        19994          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.497    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.592    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.998    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.769    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_adj_r2(model, details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Step     => 0 
      Model    => y ~ 1 
      Adj. R2  => 0 
      
      Initiating stepwise selection... 
      
                               Table: Adding New Variables                           
      ------------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2  
      ------------------------------------------------------------------------------
      x6            1    33473.297    33497.007    -23285.069    0.69145     0.69143 
      x1            1    43073.160    43096.870    -13686.868    0.50136     0.50133 
      x3            1    43267.194    43290.904    -13492.863    0.49650     0.49647 
      x2            1    43561.884    43585.595    -13198.216    0.48902     0.48900 
      x4            1    56989.595    57013.305       227.932      4e-05      -1e-05 
      x5            1    56990.439    57014.149       228.776    0.00000      -5e-05 
      ------------------------------------------------------------------------------
      
      Step     => 1 
      Added    => x6 
      Model    => y ~ x6 
      Adj. R2  => 0.69143 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x1            1    32931.758    32963.372    -23826.833    0.69972    0.69969 
      x3            1    32959.771    32991.385    -23798.829    0.69930    0.69927 
      x2            1    33033.295    33064.909    -23725.325    0.69819    0.69816 
      x4            1    33470.717    33502.331    -23288.023    0.69152    0.69149 
      x5            1    33475.275    33506.889    -23283.467    0.69145    0.69142 
      -----------------------------------------------------------------------------
      
      Step     => 2 
      Added    => x1 
      Model    => y ~ x6 + x1 
      Adj. R2  => 0.69969 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x3            1    31912.722    31952.239    -24845.827    0.71466    0.71462 
      x2            1    32025.492    32065.010    -24733.099    0.71305    0.71301 
      x4            1    32928.035    32967.552    -23830.887    0.69980    0.69976 
      x5            1    32933.735    32973.252    -23825.189    0.69972    0.69967 
      -----------------------------------------------------------------------------
      
      Step     => 3 
      Added    => x3 
      Model    => y ~ x6 + x1 + x3 
      Adj. R2  => 0.71462 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x2            1    29304.296    29351.717    -27453.243    0.74958    0.74953 
      x4            1    31908.533    31955.954    -24850.258    0.71475    0.71470 
      x5            1    31914.523    31961.944    -24844.270    0.71467    0.71461 
      -----------------------------------------------------------------------------
      
      Step     => 4 
      Added    => x2 
      Model    => y ~ x6 + x1 + x3 + x2 
      Adj. R2  => 0.74953 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x4            1    29302.797    29358.121    -27454.740    0.74962    0.74956 
      x5            1    29306.232    29361.556    -27451.307    0.74958    0.74952 
      -----------------------------------------------------------------------------
      
      Step     => 5 
      Added    => x4 
      Model    => y ~ x6 + x1 + x3 + x2 + x4 
      Adj. R2  => 0.74956 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x5            1    29304.734    29367.962    -27452.802    0.74962    0.74955 
      -----------------------------------------------------------------------------
      
      
      No more variables to be added.
      
      Variables Selected: 
      
      => x6 
      => x1 
      => x3 
      => x2 
      => x4 
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6            33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1            32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3            31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2            29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4            29302.797    29358.121    -27454.740    0.74962    0.74956 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.017 
      Pred R-Squared          0.749       AIC                29302.797 
      MAE                     0.402       SBC                29358.121 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.532            5       3032.706    11972.264    0.0000 
      Residual       5064.701        19994          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.497    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.592    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.998    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.769    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

# output from rsquared backward regression is as expected

    Code
      ols_step_backward_r2(model)
    Output
      [1] "No variables have been removed from the model."

---

    Code
      ols_step_backward_r2(model, progress = TRUE)
    Output
      Backward Elimination Method 
      ---------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Variables Removed: 
      
      
      No more variables to be removed.
      [1] "No variables have been removed from the model."

---

    Code
      ols_step_backward_r2(model, details = TRUE)
    Output
      Backward Elimination Method 
      ---------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Step     => 0 
      Model    => y ~ x1 + x2 + x3 + x4 + x5 + x6 
      R2       => 0.749623 
      
      Initiating stepwise selection... 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    29302.751    29358.075    -27454.786    0.74962    0.74956 
      x5            1    29302.797    29358.121    -27454.740    0.74962    0.74956 
      x4            1    29306.232    29361.556    -27451.307    0.74958    0.74952 
      x2            1    31910.339    31965.663    -24848.695    0.71476    0.71468 
      x3            1    32025.383    32080.708    -24733.714    0.71311    0.71304 
      x1            1    32081.673    32136.998    -24677.455    0.71230    0.71223 
      -----------------------------------------------------------------------------
      
      
      No more variables to be removed.
      
      [1] "No variables have been removed from the model."

# output from adjusted rsquared backward regression is as expected

    Code
      ols_step_backward_adj_r2(model)
    Output
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Full Model    29304.734    29367.962    -27452.802    0.74962    0.74955 
       1      x6            29302.751    29358.075    -27454.787    0.74962    0.74956 
       2      x5            29300.814    29348.235    -27456.725    0.74962    0.74957 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6430.859 
      Pred R-Squared          0.749       AIC                29300.814 
      MAE                     0.402       SBC                29348.235 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.528            4       3790.882    14966.061    0.0000 
      Residual       5064.705        19995          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x1     0.255         0.003        0.362    84.140    0.000     0.249    0.261 
               x2     0.249         0.003        0.346    80.544    0.000     0.243    0.255 
               x3     0.253         0.003        0.356    82.604    0.000     0.247    0.259 
               x4    -0.007         0.004       -0.007    -1.872    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_backward_adj_r2(model, progress = TRUE)
    Output
      Backward Elimination Method 
      ---------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Variables Removed: 
      
      => x6 
      => x5 
      
      No more variables to be removed.
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Full Model    29304.734    29367.962    -27452.802    0.74962    0.74955 
       1      x6            29302.751    29358.075    -27454.787    0.74962    0.74956 
       2      x5            29300.814    29348.235    -27456.725    0.74962    0.74957 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6430.859 
      Pred R-Squared          0.749       AIC                29300.814 
      MAE                     0.402       SBC                29348.235 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.528            4       3790.882    14966.061    0.0000 
      Residual       5064.705        19995          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x1     0.255         0.003        0.362    84.140    0.000     0.249    0.261 
               x2     0.249         0.003        0.346    80.544    0.000     0.243    0.255 
               x3     0.253         0.003        0.356    82.604    0.000     0.247    0.259 
               x4    -0.007         0.004       -0.007    -1.872    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_backward_adj_r2(model, details = TRUE)
    Output
      Backward Elimination Method 
      ---------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Step     => 0 
      Model    => y ~ x1 + x2 + x3 + x4 + x5 + x6 
      Adj. R2  => 0.7495478 
      
      Initiating stepwise selection... 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    29302.751    29358.075    -27454.786    0.74962    0.74956 
      x5            1    29302.797    29358.121    -27454.740    0.74962    0.74956 
      x4            1    29306.232    29361.556    -27451.307    0.74958    0.74952 
      x2            1    31910.339    31965.663    -24848.695    0.71476    0.71468 
      x3            1    32025.383    32080.708    -24733.714    0.71311    0.71304 
      x1            1    32081.673    32136.998    -24677.455    0.71230    0.71223 
      -----------------------------------------------------------------------------
      
      Step     => 1 
      Removed  => x6 
      Model    => y ~ x1 + x2 + x3 + x4 + x5 
      Adj. R2  => 0.74956 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x5            1    29300.814    29348.235    -27456.724    0.74962    0.74957 
      x4            1    29304.253    29351.673    -27453.287    0.74958    0.74953 
      x2            1    34920.175    34967.596    -21839.933    0.66840    0.66833 
      x3            1    35172.737    35220.158    -21587.475    0.66418    0.66412 
      x1            1    35363.070    35410.491    -21397.220    0.66097    0.66090 
      -----------------------------------------------------------------------------
      
      Step     => 2 
      Removed  => x5 
      Model    => y ~ x1 + x2 + x3 + x4 
      Adj. R2  => 0.74957 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x4            1    29302.317    29341.835    -27455.223    0.74958    0.74954 
      x2            1    34918.668    34958.185    -21840.951    0.66839    0.66834 
      x3            1    35170.915    35210.432    -21588.789    0.66418    0.66413 
      x1            1    35361.098    35400.615    -21398.670    0.66097    0.66092 
      -----------------------------------------------------------------------------
      
      
      No more variables to be removed.
      
      Variables Removed: 
      
      => x6 
      => x5 
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Full Model    29304.734    29367.962    -27452.802    0.74962    0.74955 
       1      x6            29302.751    29358.075    -27454.787    0.74962    0.74956 
       2      x5            29300.814    29348.235    -27456.725    0.74962    0.74957 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6430.859 
      Pred R-Squared          0.749       AIC                29300.814 
      MAE                     0.402       SBC                29348.235 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.528            4       3790.882    14966.061    0.0000 
      Residual       5064.705        19995          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x1     0.255         0.003        0.362    84.140    0.000     0.249    0.261 
               x2     0.249         0.003        0.346    80.544    0.000     0.243    0.255 
               x3     0.253         0.003        0.356    82.604    0.000     0.247    0.259 
               x4    -0.007         0.004       -0.007    -1.872    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

# output from rsquared both direction regression is as expected

    Code
      ols_step_both_r2(model)
    Output
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6 (+)        33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1 (+)        32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3 (+)        31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2 (+)        29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4 (+)        29302.797    29358.121    -27454.740    0.74962    0.74956 
       6      x5 (+)        29304.734    29367.962    -27452.802    0.74962    0.74955 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.168 
      Pred R-Squared          0.749       AIC                29304.734 
      MAE                     0.402       SBC                29367.962 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                        ANOVA                                    
      --------------------------------------------------------------------------
                       Sum of                                                   
                      Squares           DF    Mean Square       F          Sig. 
      --------------------------------------------------------------------------
      Regression    15163.548            6       2527.258    9976.429    0.0000 
      Residual       5064.685        19993          0.253                       
      Total         20228.233        19999                                      
      --------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.591    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.997    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.766    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.062    -0.014    0.000 
               x5    -0.001         0.004       -0.001    -0.250    0.802    -0.008    0.006 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_both_r2(model, progress = TRUE)
    Output
      Stepwise Selection Method 
      -------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Variables Added/Removed: 
      
      => x6 added 
      => x1 added 
      => x3 added 
      => x2 added 
      => x4 added 
      => x5 added 
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6 (+)        33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1 (+)        32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3 (+)        31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2 (+)        29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4 (+)        29302.797    29358.121    -27454.740    0.74962    0.74956 
       6      x5 (+)        29304.734    29367.962    -27452.802    0.74962    0.74955 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.168 
      Pred R-Squared          0.749       AIC                29304.734 
      MAE                     0.402       SBC                29367.962 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                        ANOVA                                    
      --------------------------------------------------------------------------
                       Sum of                                                   
                      Squares           DF    Mean Square       F          Sig. 
      --------------------------------------------------------------------------
      Regression    15163.548            6       2527.258    9976.429    0.0000 
      Residual       5064.685        19993          0.253                       
      Total         20228.233        19999                                      
      --------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.591    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.997    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.766    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.062    -0.014    0.000 
               x5    -0.001         0.004       -0.001    -0.250    0.802    -0.008    0.006 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_both_r2(model, details = TRUE)
    Output
      Stepwise Selection Method 
      -------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Step     => 0 
      Model    => y ~ 1 
      R2       => 0 
      
      Initiating stepwise selection... 
      
                               Table: Adding New Variables                           
      ------------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2  
      ------------------------------------------------------------------------------
      x1            1    43073.160    43096.870    -13686.868    0.50136     0.50133 
      x2            1    43561.884    43585.595    -13198.216    0.48902     0.48900 
      x3            1    43267.194    43290.904    -13492.863    0.49650     0.49647 
      x4            1    56989.595    57013.305       227.932      4e-05      -1e-05 
      x5            1    56990.439    57014.149       228.776    0.00000      -5e-05 
      x6            1    33473.297    33497.007    -23285.069    0.69145     0.69143 
      ------------------------------------------------------------------------------
      
      Step     => 1 
      Added    => x6 
      Model    => y ~ x6 
      R2       => 0.69145 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x1            1    32931.758    32963.372    -23826.833    0.69972    0.69969 
      x2            1    33033.295    33064.909    -23725.325    0.69819    0.69816 
      x3            1    32959.771    32991.385    -23798.829    0.69930    0.69927 
      x4            1    33470.717    33502.331    -23288.023    0.69152    0.69149 
      x5            1    33475.275    33506.889    -23283.467    0.69145    0.69142 
      -----------------------------------------------------------------------------
      
      Step     => 2 
      Added    => x1 
      Model    => y ~ x6 + x1 
      R2       => 0.69972 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    43073.160    43096.870    -13686.868    0.50136    0.50133 
      x1            1    33473.297    33497.007    -23285.069    0.69145    0.69143 
      -----------------------------------------------------------------------------
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x2            1    32025.492    32065.010    -24733.099    0.71305    0.71301 
      x3            1    31912.722    31952.239    -24845.827    0.71466    0.71462 
      x4            1    32928.035    32967.552    -23830.887    0.69980    0.69976 
      x5            1    32933.735    32973.252    -23825.189    0.69972    0.69967 
      -----------------------------------------------------------------------------
      
      Step     => 3 
      Added    => x3 
      Model    => y ~ x6 + x1 + x3 
      R2       => 0.71466 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    34923.269    34954.883    -21835.862    0.66828    0.66825 
      x1            1    32959.771    32991.385    -23798.829    0.69930    0.69927 
      x3            1    32931.758    32963.372    -23826.833    0.69972    0.69969 
      -----------------------------------------------------------------------------
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x2            1    29304.296    29351.717    -27453.243    0.74958    0.74953 
      x4            1    31908.533    31955.954    -24850.258    0.71475    0.71470 
      x5            1    31914.523    31961.944    -24844.270    0.71467    0.71461 
      -----------------------------------------------------------------------------
      
      Step     => 4 
      Added    => x2 
      Model    => y ~ x6 + x1 + x3 + x2 
      R2       => 0.74958 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    29302.317    29341.835    -27455.223    0.74958    0.74954 
      x1            1    32080.424    32119.941    -24678.188    0.71226    0.71222 
      x3            1    32025.492    32065.010    -24733.099    0.71305    0.71301 
      x2            1    31912.722    31952.239    -24845.827    0.71466    0.71462 
      -----------------------------------------------------------------------------
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x4            1    29302.797    29358.121    -27454.740    0.74962    0.74956 
      x5            1    29306.232    29361.556    -27451.307    0.74958    0.74952 
      -----------------------------------------------------------------------------
      
      Step     => 5 
      Added    => x4 
      Model    => y ~ x6 + x1 + x3 + x2 + x4 
      R2       => 0.74962 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    29300.814    29348.235    -27456.724    0.74962    0.74957 
      x1            1    32079.710    32127.131    -24679.159    0.71230    0.71224 
      x3            1    32023.390    32070.811    -24735.453    0.71311    0.71305 
      x2            1    31908.533    31955.954    -24850.258    0.71475    0.71470 
      x4            1    29304.296    29351.717    -27453.243    0.74958    0.74953 
      -----------------------------------------------------------------------------
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x5            1    29304.734    29367.962    -27452.802    0.74962    0.74955 
      -----------------------------------------------------------------------------
      
      Step     => 6 
      Added    => x5 
      Model    => y ~ x6 + x1 + x3 + x2 + x4 + x5 
      R2       => 0.74962 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    29302.751    29358.075    -27454.786    0.74962    0.74956 
      x1            1    32081.673    32136.998    -24677.455    0.71230    0.71223 
      x3            1    32025.383    32080.708    -24733.714    0.71311    0.71304 
      x2            1    31910.339    31965.663    -24848.695    0.71476    0.71468 
      x4            1    29306.232    29361.556    -27451.307    0.74958    0.74952 
      x5            1    29302.797    29358.121    -27454.740    0.74962    0.74956 
      -----------------------------------------------------------------------------
      
      
      Variables Selected: 
      
      => x6 
      => x1 
      => x3 
      => x2 
      => x4 
      => x5 
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6 (+)        33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1 (+)        32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3 (+)        31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2 (+)        29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x4 (+)        29302.797    29358.121    -27454.740    0.74962    0.74956 
       6      x5 (+)        29304.734    29367.962    -27452.802    0.74962    0.74955 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6431.168 
      Pred R-Squared          0.749       AIC                29304.734 
      MAE                     0.402       SBC                29367.962 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                        ANOVA                                    
      --------------------------------------------------------------------------
                       Sum of                                                   
                      Squares           DF    Mean Square       F          Sig. 
      --------------------------------------------------------------------------
      Regression    15163.548            6       2527.258    9976.429    0.0000 
      Residual       5064.685        19993          0.253                       
      Total         20228.233        19999                                      
      --------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x6     0.000         0.004       -0.002    -0.129    0.897    -0.007    0.007 
               x1     0.256         0.005        0.363    54.591    0.000     0.247    0.265 
               x3     0.253         0.005        0.356    53.997    0.000     0.244    0.262 
               x2     0.249         0.005        0.347    52.766    0.000     0.240    0.258 
               x4    -0.007         0.004       -0.007    -1.870    0.062    -0.014    0.000 
               x5    -0.001         0.004       -0.001    -0.250    0.802    -0.008    0.006 
      ---------------------------------------------------------------------------------------
      

# output from adjusted rsquared both direction regression is as expected

    Code
      ols_step_both_adj_r2(model)
    Output
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6 (+)        33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1 (+)        32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3 (+)        31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2 (+)        29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x6 (-)        29302.317    29341.835    -27455.223    0.74958    0.74954 
       6      x4 (+)        29300.814    29348.235    -27456.724    0.74962    0.74957 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6430.859 
      Pred R-Squared          0.749       AIC                29300.814 
      MAE                     0.402       SBC                29348.235 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.528            4       3790.882    14966.061    0.0000 
      Residual       5064.705        19995          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x1     0.255         0.003        0.362    84.140    0.000     0.249    0.261 
               x3     0.253         0.003        0.356    82.604    0.000     0.247    0.259 
               x2     0.249         0.003        0.346    80.544    0.000     0.243    0.255 
               x4    -0.007         0.004       -0.007    -1.872    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_both_adj_r2(model, progress = TRUE)
    Output
      Stepwise Selection Method 
      -------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Variables Added/Removed: 
      
      => x6 added 
      => x1 added 
      => x3 added 
      => x2 added 
      => x6 removed 
      => x4 added 
      
      No more variables to be added or removed.
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6 (+)        33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1 (+)        32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3 (+)        31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2 (+)        29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x6 (-)        29302.317    29341.835    -27455.223    0.74958    0.74954 
       6      x4 (+)        29300.814    29348.235    -27456.724    0.74962    0.74957 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6430.859 
      Pred R-Squared          0.749       AIC                29300.814 
      MAE                     0.402       SBC                29348.235 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.528            4       3790.882    14966.061    0.0000 
      Residual       5064.705        19995          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x1     0.255         0.003        0.362    84.140    0.000     0.249    0.261 
               x3     0.253         0.003        0.356    82.604    0.000     0.247    0.259 
               x2     0.249         0.003        0.346    80.544    0.000     0.243    0.255 
               x4    -0.007         0.004       -0.007    -1.872    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

---

    Code
      ols_step_both_adj_r2(model, details = TRUE)
    Output
      Stepwise Selection Method 
      -------------------------
      
      Candidate Terms: 
      
      1. x1 
      2. x2 
      3. x3 
      4. x4 
      5. x5 
      6. x6 
      
      
      Step     => 0 
      Model    => y ~ 1 
      Adj. R2  => 0 
      
      Initiating stepwise selection... 
      
                               Table: Adding New Variables                           
      ------------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2  
      ------------------------------------------------------------------------------
      x1            1    43073.160    43096.870    -13686.868    0.50136     0.50133 
      x2            1    43561.884    43585.595    -13198.216    0.48902     0.48900 
      x3            1    43267.194    43290.904    -13492.863    0.49650     0.49647 
      x4            1    56989.595    57013.305       227.932      4e-05      -1e-05 
      x5            1    56990.439    57014.149       228.776    0.00000      -5e-05 
      x6            1    33473.297    33497.007    -23285.069    0.69145     0.69143 
      ------------------------------------------------------------------------------
      
      Step     => 1 
      Added    => x6 
      Model    => y ~ x6 
      Adj. R2  => 0.69143 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x1            1    32931.758    32963.372    -23826.833    0.69972    0.69969 
      x2            1    33033.295    33064.909    -23725.325    0.69819    0.69816 
      x3            1    32959.771    32991.385    -23798.829    0.69930    0.69927 
      x4            1    33470.717    33502.331    -23288.023    0.69152    0.69149 
      x5            1    33475.275    33506.889    -23283.467    0.69145    0.69142 
      -----------------------------------------------------------------------------
      
      Step     => 2 
      Added    => x1 
      Model    => y ~ x6 + x1 
      Adj. R2  => 0.69969 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    43073.160    43096.870    -13686.868    0.50136    0.50133 
      x1            1    33473.297    33497.007    -23285.069    0.69145    0.69143 
      -----------------------------------------------------------------------------
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x2            1    32025.492    32065.010    -24733.099    0.71305    0.71301 
      x3            1    31912.722    31952.239    -24845.827    0.71466    0.71462 
      x4            1    32928.035    32967.552    -23830.887    0.69980    0.69976 
      x5            1    32933.735    32973.252    -23825.189    0.69972    0.69967 
      -----------------------------------------------------------------------------
      
      Step     => 3 
      Added    => x3 
      Model    => y ~ x6 + x1 + x3 
      Adj. R2  => 0.71462 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    34923.269    34954.883    -21835.862    0.66828    0.66825 
      x1            1    32959.771    32991.385    -23798.829    0.69930    0.69927 
      x3            1    32931.758    32963.372    -23826.833    0.69972    0.69969 
      -----------------------------------------------------------------------------
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x2            1    29304.296    29351.717    -27453.243    0.74958    0.74953 
      x4            1    31908.533    31955.954    -24850.258    0.71475    0.71470 
      x5            1    31914.523    31961.944    -24844.270    0.71467    0.71461 
      -----------------------------------------------------------------------------
      
      Step     => 4 
      Added    => x2 
      Model    => y ~ x6 + x1 + x3 + x2 
      Adj. R2  => 0.74953 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x6            1    29302.317    29341.835    -27455.223    0.74958    0.74954 
      x1            1    32080.424    32119.941    -24678.188    0.71226    0.71222 
      x3            1    32025.492    32065.010    -24733.099    0.71305    0.71301 
      x2            1    31912.722    31952.239    -24845.827    0.71466    0.71462 
      -----------------------------------------------------------------------------
      
      Step     => 5 
      Removed  => x6 
      Model    => y ~ x1 + x3 + x2 
      Adj. R2  => 0.74954 
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x4            1    29300.814    29348.235    -27456.724    0.74962    0.74957 
      x5            1    29304.253    29351.673    -27453.287    0.74958    0.74953 
      -----------------------------------------------------------------------------
      
      Step     => 6 
      Added    => x4 
      Model    => y ~ x1 + x3 + x2 + x4 
      Adj. R2  => 0.74957 
      
                           Table: Removing Existing Variables                       
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x1            1    35361.098    35400.615    -21398.670    0.66097    0.66092 
      x3            1    35170.915    35210.432    -21588.789    0.66418    0.66413 
      x2            1    34918.668    34958.185    -21840.951    0.66839    0.66834 
      x4            1    29302.317    29341.835    -27455.223    0.74958    0.74954 
      -----------------------------------------------------------------------------
      
                               Table: Adding New Variables                          
      -----------------------------------------------------------------------------
      Predictor    DF       AIC          SBC          SBIC         R2       Adj. R2 
      -----------------------------------------------------------------------------
      x5            1    29302.751    29358.075    -27454.786    0.74962    0.74956 
      -----------------------------------------------------------------------------
      
      
      No more variables to be added or removed.
      
      Variables Selected: 
      
      => x1 
      => x3 
      => x2 
      => x4 
      
      
                                       Stepwise Summary                                 
      --------------------------------------------------------------------------------
      Step    Variable         AIC          SBC          SBIC         R2       Adj. R2 
      --------------------------------------------------------------------------------
       0      Base Model    56988.482    57004.289       228.318    0.00000    0.00000 
       1      x6 (+)        33473.297    33497.007    -23285.069    0.69145    0.69143 
       2      x1 (+)        32931.758    32963.372    -23826.833    0.69972    0.69969 
       3      x3 (+)        31912.722    31952.239    -24845.827    0.71466    0.71462 
       4      x2 (+)        29304.296    29351.717    -27453.243    0.74958    0.74953 
       5      x6 (-)        29302.317    29341.835    -27455.223    0.74958    0.74954 
       6      x4 (+)        29300.814    29348.235    -27456.724    0.74962    0.74957 
      --------------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                Model Summary                           
      -----------------------------------------------------------------
      R                       0.866       RMSE                   0.503 
      R-Squared               0.750       MSE                    0.253 
      Adj. R-Squared          0.750       Coef. Var           6430.859 
      Pred R-Squared          0.749       AIC                29300.814 
      MAE                     0.402       SBC                29348.235 
      -----------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                         ANOVA                                    
      ---------------------------------------------------------------------------
                       Sum of                                                    
                      Squares           DF    Mean Square        F          Sig. 
      ---------------------------------------------------------------------------
      Regression    15163.528            4       3790.882    14966.061    0.0000 
      Residual       5064.705        19995          0.253                        
      Total         20228.233        19999                                       
      ---------------------------------------------------------------------------
      
                                        Parameter Estimates                                   
      ---------------------------------------------------------------------------------------
            model      Beta    Std. Error    Std. Beta      t        Sig      lower    upper 
      ---------------------------------------------------------------------------------------
      (Intercept)    -0.005         0.004                 -1.496    0.135    -0.012    0.002 
               x1     0.255         0.003        0.362    84.140    0.000     0.249    0.261 
               x3     0.253         0.003        0.356    82.604    0.000     0.247    0.259 
               x2     0.249         0.003        0.346    80.544    0.000     0.243    0.255 
               x4    -0.007         0.004       -0.007    -1.872    0.061    -0.014    0.000 
      ---------------------------------------------------------------------------------------
      

